/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.bukkit.AdminCmd;

import be.Balor.Manager.LocaleManager;
import be.Balor.Tools.Configuration.File.ExtendedConfiguration;
import be.Balor.Tools.Files.FileManager;
import be.Balor.Tools.Utils;
import java.io.IOException;

public enum TextLocale {
    NEWS("NEWS"),
    RULES("Rules"),
    MOTD("MOTD"),
    MOTD_NEW("MOTDNewUser", "motdNewUser");

    private final String locale;
    private final String file;
    private static ExtendedConfiguration version;

    private TextLocale(String locale) {
        this.locale = locale;
        this.file = this.locale.toLowerCase();
    }

    private TextLocale(String locale, String file) {
        this.locale = locale;
        this.file = file;
    }

    public void saveContent(String content) {
        LocaleManager.getInstance().addLocale(this.locale, content, true);
        FileManager.getInstance().setTxtFile(this.file, content);
        version.set(this.file, System.currentTimeMillis());
        try {
            version.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reloadContent() {
        String result = Utils.colorParser(FileManager.getInstance().getTextFile(this.file + ".txt"));
        LocaleManager.getInstance().addLocale(this.locale, result, true);
        version.set(this.file, System.currentTimeMillis());
        try {
            version.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void setVersion(ExtendedConfiguration version) {
        TextLocale.version = version;
    }

    public long getModifTime() {
        return version.getLong(this.file, 0L);
    }
}

