/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.bukkit.AdminCmd;

import be.Balor.Manager.CommandManager;
import be.Balor.Manager.Commands.CoreCommand;
import be.Balor.Tools.Debug.ACLogger;
import be.Balor.Tools.Debug.DebugLog;
import be.Balor.Tools.Metrics.Metrics;
import be.Balor.bukkit.AdminCmd.AbstractAdminCmdPlugin;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class ACPluginManager {
    private static final ACPluginManager instance = new ACPluginManager();
    private final Map<String, AbstractAdminCmdPlugin> pluginInstances = Collections.synchronizedMap(new HashMap());
    private static final Server server = Bukkit.getServer();
    private static AbstractAdminCmdPlugin corePlugin;
    private static Metrics.Graph graph;

    protected static ACPluginManager getInstance() {
        return instance;
    }

    public static AbstractAdminCmdPlugin getPluginInstance(String name) {
        return ACPluginManager.getInstance().getPlugin(name);
    }

    public static BukkitScheduler getScheduler() {
        return server.getScheduler();
    }

    public static Server getServer() {
        return server;
    }

    public static void registerACPlugin(AbstractAdminCmdPlugin addon) throws IllegalArgumentException {
        ACPluginManager.getInstance().registerPlugin(addon);
    }

    public static void registerCommand(Class<? extends CoreCommand> clazz) throws IllegalArgumentException {
        CommandManager.getInstance().registerCommand(clazz);
    }

    public static int scheduleSyncTask(Runnable task) {
        return server.getScheduler().scheduleSyncDelayedTask((Plugin)corePlugin, task);
    }

    public static int scheduleAsyncDelayedTask(Runnable task) {
        return server.getScheduler().scheduleAsyncDelayedTask((Plugin)corePlugin, task);
    }

    static void setCorePlugin(AbstractAdminCmdPlugin corePlugin) {
        ACPluginManager.corePlugin = corePlugin;
    }

    public static AbstractAdminCmdPlugin getCorePlugin() {
        return corePlugin;
    }

    static void setMetrics(Metrics metrics) {
        graph = metrics.createGraph("Plugins");
    }

    public static void unRegisterACPlugin(Plugin addon) {
        if (addon instanceof AbstractAdminCmdPlugin) {
            ACPluginManager.getInstance().unRegisterPlugin((AbstractAdminCmdPlugin)addon);
        }
    }

    private ACPluginManager() {
    }

    protected AbstractAdminCmdPlugin getPlugin(String name) {
        return this.pluginInstances.get(name);
    }

    protected void registerPlugin(final AbstractAdminCmdPlugin addon) throws IllegalArgumentException {
        if (!this.pluginInstances.containsKey(addon.getAddonName())) {
            this.pluginInstances.put(addon.getAddonName(), addon);
            DebugLog.INSTANCE.info("Registering : " + (Object)((Object)addon));
            if (corePlugin == null || addon.equals((Object)corePlugin)) {
                return;
            }
        } else {
            throw new IllegalArgumentException("Plugin " + addon.getAddonName() + " Already registered.");
        }
        graph.addPlotter(new Metrics.Plotter(){

            @Override
            public int getValue() {
                return 1;
            }

            @Override
            public String getColumnName() {
                return "Addon " + addon.getAddonName();
            }
        });
    }

    void stopChildrenPlugins() {
        ACLogger.info("Disabling all AdminCmd's plugins");
        for (Map.Entry<String, AbstractAdminCmdPlugin> plugin : this.pluginInstances.entrySet()) {
            if (!plugin.getValue().isEnabled()) continue;
            server.getPluginManager().disablePlugin((Plugin)plugin.getValue());
        }
    }

    protected void unRegisterPlugin(final AbstractAdminCmdPlugin addon) {
        this.pluginInstances.remove(addon.getAddonName());
        if (!addon.equals((Object)corePlugin)) {
            graph.removePlotter(new Metrics.Plotter(){

                @Override
                public int getValue() {
                    return 1;
                }

                @Override
                public String getColumnName() {
                    return "Addon " + addon.getAddonName();
                }
            });
        }
    }

    static {
        graph = null;
    }
}

