/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.bukkit.AdminCmd;

import be.Balor.Manager.CommandManager;
import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Exceptions.NoPermissionsPlugin;
import be.Balor.Manager.Exceptions.WorldNotLoaded;
import be.Balor.Manager.LocaleManager;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Player.ACPlayer;
import be.Balor.Player.Ban;
import be.Balor.Player.BannedIP;
import be.Balor.Player.FilePlayer;
import be.Balor.Player.FilePlayerFactory;
import be.Balor.Player.IBan;
import be.Balor.Player.ITempBan;
import be.Balor.Player.PlayerManager;
import be.Balor.Tools.Blocks.BlockRemanence;
import be.Balor.Tools.Configuration.ExConfigurationSection;
import be.Balor.Tools.Configuration.File.ExtendedConfiguration;
import be.Balor.Tools.Debug.ACLogger;
import be.Balor.Tools.Debug.DebugLog;
import be.Balor.Tools.Exceptions.InvalidInputException;
import be.Balor.Tools.Files.DataManager;
import be.Balor.Tools.Files.FileManager;
import be.Balor.Tools.Files.KitInstance;
import be.Balor.Tools.Help.HelpLister;
import be.Balor.Tools.Help.HelpLoader;
import be.Balor.Tools.Lister.Lister;
import be.Balor.Tools.MaterialContainer;
import be.Balor.Tools.Threads.SetTimeTask;
import be.Balor.Tools.Threads.UnBanTask;
import be.Balor.Tools.Threads.UndoBlockTask;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.World.ACWorld;
import be.Balor.World.FileWorldFactory;
import be.Balor.World.WorldManager;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.AbstractAdminCmdPlugin;
import be.Balor.bukkit.AdminCmd.AdminCmd;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import be.Balor.bukkit.AdminCmd.LocaleHelper;
import be.Balor.bukkit.AdminCmd.TextLocale;
import belgium.Balor.Workers.AFKWorker;
import belgium.Balor.Workers.InvisibleWorker;
import com.google.common.collect.MapMaker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ACHelper {
    private static final HashMap<Material, String[]> materialsColors;
    private static final List<Integer> listOfPossibleRepair;
    private FileManager fManager;
    private final Set<MaterialContainer> itemBlacklist = new TreeSet<MaterialContainer>();
    private List<Integer> blockBlacklist;
    private List<String> groups;
    private AdminCmd coreInstance;
    private final ConcurrentMap<String, MaterialContainer> alias = new MapMaker().makeMap();
    private Map<String, KitInstance> kits = new HashMap<String, KitInstance>();
    private final ConcurrentMap<String, IBan> bannedPlayers = new MapMaker().makeMap();
    private final ConcurrentMap<Player, Object> fakeQuitPlayers = new MapMaker().makeMap();
    private final ConcurrentMap<Player, Object> spyPlayers = new MapMaker().makeMap();
    private static ACHelper instance;
    private final ConcurrentMap<String, Stack<Stack<BlockRemanence>>> undoQueue = new MapMaker().makeMap();
    private static long pluginStarted;
    private ExtendedConfiguration pluginConfig;
    private DataManager dataManager;
    private boolean serverLocked = false;
    private final ConcurrentMap<Player, Player> playersForReplyMessage = new MapMaker().makeMap();

    public static Long[] getElapsedTime() {
        return Utils.getElapsedTime(pluginStarted);
    }

    public static ACHelper getInstance() {
        return instance;
    }

    static void killInstance() {
        instance = null;
    }

    public void banPlayer(IBan ban) {
        Lister list;
        this.bannedPlayers.put(ban.getPlayer(), ban);
        this.dataManager.addBan(ban);
        if (ban instanceof BannedIP) {
            ACPluginManager.getServer().banIP(ban.getPlayer());
        }
        if ((list = Lister.getLister(Lister.List.BAN, false)) != null) {
            list.update();
        }
    }

    public boolean addBlackListedBlock(CommandSender sender, String name) {
        MaterialContainer m = this.checkMaterial(sender, name);
        if (!m.isNull()) {
            ExtendedConfiguration config = this.fManager.getYml("blacklist");
            List<Integer> list = config.getIntList("BlackListedBlocks", null);
            if (list == null) {
                list = new ArrayList<Integer>();
            }
            list.add(m.getMaterial().getId());
            config.set("BlackListedBlocks", list);
            try {
                config.save();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (this.blockBlacklist == null) {
                this.blockBlacklist = new ArrayList<Integer>();
            }
            this.blockBlacklist.add(m.getMaterial().getId());
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("material", m.getMaterial().toString());
            Utils.sI18n(sender, "addBlacklistBlock", replace);
            return true;
        }
        return false;
    }

    public boolean addBlackListedItem(CommandSender sender, String name) {
        MaterialContainer m = this.checkMaterial(sender, name);
        return this.addBlackListedItem(sender, m);
    }

    public boolean addBlackListedItem(CommandSender sender, ItemStack item) {
        MaterialContainer m = new MaterialContainer(item);
        return this.addBlackListedItem(sender, m);
    }

    private boolean addBlackListedItem(CommandSender sender, MaterialContainer mat) {
        if (mat.isNull()) {
            return false;
        }
        if (!this.itemBlacklist.add(mat)) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("item", mat.display());
            LocaleHelper.BL_ITEM_ALREADY.sendLocale(sender, replace);
            return false;
        }
        ExtendedConfiguration config = this.fManager.getYml("blacklist");
        config.set("BlackListedMaterial", this.itemBlacklist);
        try {
            config.save();
        }
        catch (IOException e) {
            DebugLog.INSTANCE.log(Level.WARNING, "Can't save the blacklist", e);
            LocaleHelper.BL_ITEM_PROBLEM.sendLocale(sender);
            return false;
        }
        Utils.sI18n(sender, "addBlacklistItem", "material", mat.display());
        return true;
    }

    public void addFakeQuit(Player p) {
        this.fakeQuitPlayers.put(p, new Object());
    }

    public void addInUndoQueue(String player, Stack<BlockRemanence> blocks) {
        if (this.undoQueue.containsKey(player)) {
            ((Stack)this.undoQueue.get(player)).push(blocks);
        } else {
            Stack<Stack<BlockRemanence>> blockQueue = new Stack<Stack<BlockRemanence>>();
            blockQueue.push(blocks);
            this.undoQueue.put(player, blockQueue);
        }
    }

    private void addLocaleFromFile() {
        String locale = this.fManager.getTextFile("motd.txt");
        if (locale == null) {
            ACLogger.info("Could not read motd.txt. Using default values for the MotD!");
            Utils.addLocale("MOTD", ChatColor.GOLD + "Welcome " + ChatColor.WHITE + "%player" + ChatColor.GOLD + ", there is currently " + ChatColor.DARK_RED + "%nb players connected : //n" + ChatColor.GOLD + "%connected //n" + ChatColor.DARK_GREEN + "You've played so far : " + ChatColor.AQUA + "#elapsedTotalTime# //n" + ChatColor.DARK_GREEN + "Your last login was: " + ChatColor.AQUA + "%lastlogin", true);
        } else {
            ACLogger.info("motd.txt loaded");
            Utils.addLocale("MOTD", Utils.colorParser(locale), true);
        }
        locale = this.fManager.getTextFile("motdNewUser.txt");
        if (locale == null) {
            ACLogger.info("Could not read motdNewUser.txt. Using default values for the MotDNewUser!");
            Utils.addLocale("MOTDNewUser", ChatColor.GOLD + "Welcome " + ChatColor.WHITE + "%player" + ChatColor.GOLD + ", there is currently " + ChatColor.DARK_RED + "%nb players connected : //n" + ChatColor.GOLD + "%connected //n" + ChatColor.DARK_GREEN + "You've played so far : " + ChatColor.AQUA + "#elapsedTotalTime#", true);
        } else {
            ACLogger.info("motdNewUser.txt loaded");
            Utils.addLocale("MOTDNewUser", Utils.colorParser(locale), true);
        }
        locale = this.fManager.getTextFile("news.txt");
        if (locale == null) {
            ACLogger.info("Could not read news.txt. Using default values for the MotD!");
            Utils.addLocale("NEWS", ChatColor.DARK_GREEN + "News : AdminCmd Plugin has been installed", true);
        } else {
            ACLogger.info("news.txt loaded");
            Utils.addLocale("NEWS", Utils.colorParser(locale), true);
        }
        locale = this.fManager.getTextFile("rules.txt");
        if (locale == null) {
            ACLogger.info("Could not read motdNewUser.txt. Using default values for the MotD!");
            Utils.addLocale("Rules", "1. Do not grief! //n2. Do not use strong language! //n3. Be friendly to other players!", true);
        } else {
            ACLogger.info("rules.txt loaded");
            Utils.addLocale("Rules", Utils.colorParser(locale), true);
        }
        LocaleManager.getInstance().save();
    }

    public void addSpy(Player p) {
        this.spyPlayers.put(p, new Object());
    }

    public boolean alias(CommandSender sender, CommandArgs args) {
        MaterialContainer m = this.checkMaterial(sender, args.getString(1));
        if (m.isNull()) {
            return true;
        }
        String alias = args.getString(0);
        this.alias.put(alias, m);
        this.fManager.addAlias(alias, m);
        sender.sendMessage(ChatColor.BLUE + "You can now use " + ChatColor.GOLD + alias + ChatColor.BLUE + " for the item " + ChatColor.GOLD + m.display());
        return true;
    }

    private boolean checkBan(IBan player) {
        if (player instanceof ITempBan) {
            ITempBan tempBan = (ITempBan)player;
            Long timeLeft = tempBan.timeLeft();
            if (timeLeft <= 0L) {
                this.unBanPlayer(player);
                return false;
            }
            ACPluginManager.getScheduler().scheduleAsyncDelayedTask((Plugin)this.coreInstance, (Runnable)new UnBanTask(tempBan, true), timeLeft / 1000L * 20L);
            return true;
        }
        return true;
    }

    public MaterialContainer checkMaterial(CommandSender sender, String mat) {
        MaterialContainer m = null;
        try {
            m = Utils.checkMaterial(mat);
        }
        catch (InvalidInputException e) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("material", mat);
            Utils.sI18n(sender, "unknownMat", replace);
            return new MaterialContainer();
        }
        if (m.isNull()) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("material", mat);
            Utils.sI18n(sender, "unknownMat", replace);
        }
        return m;
    }

    private void convertSpawnWarp() {
        File warpFile;
        File spawnFile = this.fManager.getFile("spawn", "spawnLocations.yml", false);
        if (spawnFile.exists()) {
            ExtendedConfiguration spawn = ExtendedConfiguration.loadConfiguration(spawnFile);
            ExConfigurationSection spawnPoints = spawn.getConfigurationSection("spawn");
            if (spawnPoints != null) {
                for (String key : spawnPoints.getKeys(false)) {
                    try {
                        ACWorld.getWorld(key).setSpawn(this.fManager.getLocation("spawn." + key, "spawnLocations", "spawn"));
                    }
                    catch (WorldNotLoaded e) {}
                }
            }
            spawnFile.delete();
            spawnFile.getParentFile().delete();
        }
        if ((warpFile = this.fManager.getFile("warp", "warpPoints.yml", false)).exists()) {
            for (String key : this.fManager.getKeys("warp", "warpPoints", "warp")) {
                try {
                    Location loc = this.fManager.getLocation("warp." + key, "warpPoints", "warp");
                    ACWorld.getWorld(loc.getWorld().getName()).addWarp(key, loc);
                }
                catch (WorldNotLoaded e) {}
            }
            warpFile.delete();
            warpFile.getParentFile().delete();
        }
    }

    public int countBannedPlayers() {
        return this.bannedPlayers.size();
    }

    public int countBlackListedItems() {
        return this.itemBlacklist.size();
    }

    public Collection<IBan> getBannedPlayers() {
        return this.bannedPlayers.values();
    }

    public MaterialContainer getAlias(String name) {
        return (MaterialContainer)this.alias.get(name);
    }

    private List<Integer> getBlackListedBlocks() {
        return this.fManager.getYml("blacklist").getIntList("BlackListedBlocks", new ArrayList<Integer>());
    }

    private Set<MaterialContainer> getBlackListedItems() {
        return (Set)this.fManager.getYml("blacklist").get("BlackListedMaterial", new TreeSet());
    }

    private short getColor(String name, Material mat) {
        int value = -1;
        try {
            value = Short.parseShort(name);
        }
        catch (Exception e) {
            for (int i = 0; i < materialsColors.get(mat).length; i = (int)((short)(i + 1))) {
                if (!materialsColors.get(mat)[i].equalsIgnoreCase(name)) continue;
                value = i;
                break;
            }
        }
        if (value < 0 || value >= materialsColors.get(mat).length) {
            return -1;
        }
        return (short)value;
    }

    public AbstractAdminCmdPlugin getCoreInstance() {
        return this.coreInstance;
    }

    public Set<Player> getFakeQuitPlayers() {
        return this.fakeQuitPlayers.keySet();
    }

    public List<String> getGroupList() {
        return this.groups;
    }

    private List<String> getGroupNames() {
        return this.fManager.getYml("config").getStringList("groupNames", new ArrayList<String>());
    }

    public KitInstance getKit(String kit) {
        return this.kits.get(kit);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getKitList(CommandSender sender) {
        String kitList = "";
        HashSet<String> list = new HashSet<String>();
        try {
            list.addAll(this.kits.keySet());
            if (Utils.oddItem == null) {
                // empty if block
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        for (String kit : list) {
            if (!PermissionManager.hasPerm(sender, "admincmd.kit." + kit, false)) continue;
            kitList = kitList + kit + ", ";
        }
        if (!kitList.equals("") && kitList.endsWith(", ")) {
            kitList = kitList.substring(0, kitList.lastIndexOf(","));
        }
        return kitList.trim();
    }

    public int getLimit(CommandSender sender, Type.Limit type) {
        if (sender instanceof ConsoleCommandSender) {
            return Integer.MAX_VALUE;
        }
        return this.getLimit((Player)sender, type, type.toString());
    }

    public int getLimit(Player player, Type.Limit type) {
        return this.getLimit(player, type, type.toString());
    }

    public int getLimit(Player player, Type.Limit type, String defaultLvl) {
        Integer limit = null;
        String toParse = PermissionManager.getPermissionLimit(player, type.toString());
        Integer n = limit = toParse != null && !toParse.isEmpty() ? Integer.valueOf(Integer.parseInt(toParse)) : null;
        if (limit == null || limit == -1) {
            limit = this.pluginConfig.getInt(defaultLvl, 0);
        }
        if (limit == 0 && type != Type.Limit.IMMUNITY) {
            limit = Integer.MAX_VALUE;
        }
        return limit;
    }

    public int getNbKit() {
        return this.kits.size();
    }

    public Player getReplyPlayer(Player key) {
        return (Player)this.playersForReplyMessage.get(key);
    }

    public Set<Player> getSpyPlayers() {
        return this.spyPlayers.keySet();
    }

    public void groupSpawn(CommandSender sender) {
        if (Utils.isPlayer(sender)) {
            Player player = (Player)sender;
            Location loc = null;
            String worldName = player.getWorld().getName();
            if (this.groups.isEmpty()) {
                loc = ACWorld.getWorld(worldName).getSpawn();
                if (loc == null) {
                    loc = player.getWorld().getSpawnLocation();
                }
                player.teleport(loc);
                Utils.sI18n(sender, "spawn");
                return;
            }
            Iterator<String> i$ = this.groups.iterator();
            if (i$.hasNext()) {
                String groupName = i$.next();
                try {
                    if (PermissionManager.isInGroup(groupName, player)) {
                        loc = ACWorld.getWorld((String)worldName).getWarp((String)new StringBuilder().append((String)"spawn").append((String)groupName.toLowerCase()).toString()).loc;
                    }
                }
                catch (NoPermissionsPlugin e) {
                    loc = ACWorld.getWorld(worldName).getSpawn();
                }
            }
            if (loc == null) {
                loc = player.getWorld().getSpawnLocation();
            }
            player.teleport(loc);
            Utils.sI18n(sender, "spawn");
        }
    }

    public boolean inBlackListBlock(CommandSender sender, ItemStack mat) {
        if (!PermissionManager.hasPerm(sender, "admincmd.spec.noblacklist", false) && this.blockBlacklist.contains(mat.getTypeId())) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("material", mat.getType().toString());
            Utils.sI18n(sender, "inBlacklistBlock", replace);
            return true;
        }
        return false;
    }

    public boolean inBlackListBlock(CommandSender sender, MaterialContainer mat) {
        if (!PermissionManager.hasPerm(sender, "admincmd.spec.noblacklist", false) && this.blockBlacklist.contains(mat.getMaterial().getId())) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("material", mat.display());
            Utils.sI18n(sender, "inBlacklistBlock", replace);
            return true;
        }
        return false;
    }

    public boolean inBlackListItem(CommandSender sender, ItemStack mat) {
        return this.inBlackListItem(sender, new MaterialContainer(mat));
    }

    public boolean inBlackListItem(CommandSender sender, MaterialContainer mat) {
        if (PermissionManager.hasPerm(sender, "admincmd.spec.noblacklist", false)) {
            return false;
        }
        if (!this.itemBlacklist.contains(mat)) {
            return false;
        }
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("material", mat.display());
        Utils.sI18n(sender, "inBlacklistItem", replace);
        return true;
    }

    private void init() {
        AFKWorker.createInstance();
        if (this.pluginConfig.getBoolean("autoAfk", true)) {
            AFKWorker.getInstance().setAfkTime(this.pluginConfig.getInt("afkTimeInSecond", 60));
            AFKWorker.getInstance().setKickTime(this.pluginConfig.getInt("afkKickInMinutes", 3));
            this.coreInstance.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this.coreInstance, (Runnable)AFKWorker.getInstance().getAfkChecker(), 0L, (long)(this.pluginConfig.getInt("statutCheckInSec", 20) * 20));
            if (this.pluginConfig.getBoolean("autoKickAfkPlayer", false)) {
                this.coreInstance.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this.coreInstance, (Runnable)AFKWorker.getInstance().getKickChecker(), 0L, (long)(this.pluginConfig.getInt("statutCheckInSec", 20) * 20));
            }
        }
        LocaleManager.getInstance().addLocaleFile("primary", new File(this.coreInstance.getDataFolder(), "locales" + File.separator + this.pluginConfig.getString("locale", "en_US") + ".yml"));
        LocaleManager.getInstance().addLocaleFile("kickMessages", this.fManager.getInnerFile("kickMessages.yml", "locales", false));
        LocaleManager.getInstance().setNoMsg(this.pluginConfig.getBoolean("noMessage", false));
        HelpLoader.load(this.coreInstance.getDataFolder());
        CommandManager.createInstance().setCorePlugin(this.coreInstance);
        if (this.pluginConfig.get("pluginStarted") != null) {
            pluginStarted = Long.parseLong(this.pluginConfig.getString("pluginStarted"));
            this.pluginConfig.remove("pluginStarted");
            try {
                this.pluginConfig.save();
            }
            catch (IOException e) {}
        } else {
            pluginStarted = System.currentTimeMillis();
        }
        for (Player p : this.coreInstance.getServer().getOnlinePlayers()) {
            PlayerManager.getInstance().setOnline(p);
        }
        FilePlayer.scheduleAsyncSave();
        if (this.pluginConfig.getBoolean("tpRequestActivatedByDefault", false)) {
            for (Player p : this.coreInstance.getServer().getOnlinePlayers()) {
                ACPlayer.getPlayer(p).setPower(Type.TP_REQUEST);
            }
        }
        for (World w : this.coreInstance.getServer().getWorlds()) {
            ACWorld world = ACWorld.getWorld(w.getName());
            int task = world.getInformation(Type.TIME_FREEZED.toString()).getInt(-1);
            if (task == -1) continue;
            task = ACPluginManager.getScheduler().scheduleSyncRepeatingTask((Plugin)ACHelper.getInstance().getCoreInstance(), (Runnable)new SetTimeTask(w), 0L, 5L);
            world.setInformation(Type.TIME_FREEZED.toString(), task);
        }
    }

    public IBan getBan(String player) {
        return (IBan)this.bannedPlayers.get(player);
    }

    public boolean isServerLocked() {
        return this.serverLocked;
    }

    public boolean itemColor(CommandSender sender, String color) {
        if (Utils.isPlayer(sender)) {
            if (color.equalsIgnoreCase("help")) {
                sender.sendMessage(ChatColor.RED + "Wool: " + ChatColor.WHITE + this.printColors(Material.WOOL));
                sender.sendMessage(ChatColor.RED + "Dyes: " + ChatColor.WHITE + this.printColors(Material.INK_SACK));
                sender.sendMessage(ChatColor.RED + "Logs: " + ChatColor.WHITE + this.printColors(Material.LOG));
                sender.sendMessage(ChatColor.RED + "Slab: " + ChatColor.WHITE + this.printColors(Material.STEP));
                return true;
            }
            short value = -1;
            Material m = ((Player)sender).getItemInHand().getType();
            if (!materialsColors.containsKey(m)) {
                sender.sendMessage(ChatColor.RED + "You must hold a colorable material!");
                return true;
            }
            value = this.getColor(color, m);
            if (value < 0) {
                sender.sendMessage(ChatColor.RED + "Color " + ChatColor.WHITE + color + ChatColor.RED + " is not usable for what you're holding!");
                return true;
            }
            final Player player = (Player)sender;
            final short colorVal = value;
            ACPluginManager.scheduleSyncTask(new Runnable(){

                @Override
                public void run() {
                    player.getItemInHand().setDurability(colorVal);
                }
            });
        }
        return true;
    }

    public synchronized void loadInfos() {
        this.itemBlacklist.addAll(this.getBlackListedItems());
        this.blockBlacklist = this.getBlackListedBlocks();
        this.groups = this.getGroupNames();
        this.alias.putAll(this.fManager.getAlias());
        this.addLocaleFromFile();
        this.kits = this.fManager.loadKits();
        Map<String, Ban> bans = this.dataManager.loadBan();
        for (Map.Entry<String, Ban> ban : bans.entrySet()) {
            if (!this.checkBan(ban.getValue())) continue;
            this.bannedPlayers.put(ban.getKey(), ban.getValue());
        }
        if (this.pluginConfig.getBoolean("verboseLog", true)) {
            Logger.getLogger("Minecraft").info("[AdminCmd] " + this.itemBlacklist.size() + " blacklisted items loaded.");
            Logger.getLogger("Minecraft").info("[AdminCmd] " + this.blockBlacklist.size() + " blacklisted blocks loaded.");
            Logger.getLogger("Minecraft").info("[AdminCmd] " + this.alias.size() + " alias loaded.");
            Logger.getLogger("Minecraft").info("[AdminCmd] " + this.kits.size() + " kits loaded.");
            Logger.getLogger("Minecraft").info("[AdminCmd] " + this.bannedPlayers.size() + " banned players loaded.");
        }
    }

    private String printColors(Material mat) {
        String output = "";
        for (int i = 0; i < materialsColors.get(mat).length; ++i) {
            output = output + materialsColors.get(mat)[i] + ", ";
        }
        return output;
    }

    public synchronized void reload() {
        this.coreInstance.getServer().getScheduler().cancelTasks((Plugin)this.coreInstance);
        FilePlayer.forceSaveList();
        this.alias.clear();
        this.itemBlacklist.clear();
        this.blockBlacklist.clear();
        this.groups.clear();
        this.undoQueue.clear();
        try {
            this.pluginConfig.reload();
        }
        catch (FileNotFoundException e) {
            ACLogger.severe("Config Reload Problem :", e);
        }
        catch (IOException e) {
            ACLogger.severe("Config Reload Problem :", e);
        }
        catch (InvalidConfigurationException e) {
            ACLogger.severe("Config Reload Problem :", e);
        }
        this.bannedPlayers.clear();
        this.loadInfos();
        for (Player p : InvisibleWorker.getInstance().getAllInvisiblePlayers()) {
            InvisibleWorker.getInstance().reappear(p);
        }
        InvisibleWorker.killInstance();
        AFKWorker.killInstance();
        CommandManager.killInstance();
        HelpLister.killInstance();
        System.gc();
        this.init();
        CommandManager.getInstance().registerACPlugin(this.coreInstance);
        this.coreInstance.registerCmds();
        CommandManager.getInstance().checkAlias(this.coreInstance);
        if (ConfigEnum.H_ALLPLUGIN.getBoolean()) {
            for (Plugin plugin : this.coreInstance.getServer().getPluginManager().getPlugins()) {
                HelpLister.getInstance().addPlugin(plugin);
            }
        }
        if (this.pluginConfig.getBoolean("autoAfk", true)) {
            for (Player p : Utils.getOnlinePlayers()) {
                AFKWorker.getInstance().updateTimeStamp(p);
            }
        }
    }

    public boolean removeBlackListedBlock(CommandSender sender, String name) {
        MaterialContainer m = this.checkMaterial(sender, name);
        if (!m.isNull()) {
            ExtendedConfiguration config = this.fManager.getYml("blacklist");
            List<Integer> list = config.getIntList("BlackListedBlocks", new ArrayList<Integer>());
            if (!list.isEmpty() && list.contains(m.getMaterial().getId())) {
                list.remove((Object)m.getMaterial().getId());
                config.set("BlackListedBlocks", list);
                try {
                    config.save();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.itemBlacklist != null && !this.itemBlacklist.isEmpty() && this.itemBlacklist.contains(m.getMaterial().getId())) {
                this.itemBlacklist.remove(m.getMaterial().getId());
            }
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("material", m.getMaterial().toString());
            Utils.sI18n(sender, "rmBlacklistBlock", replace);
            return true;
        }
        return false;
    }

    public boolean removeBlackListedItem(CommandSender sender, String name) {
        MaterialContainer m = this.checkMaterial(sender, name);
        return this.removeBlackListedItem(sender, m);
    }

    public boolean removeBlackListedItem(CommandSender sender, ItemStack item) {
        MaterialContainer m = new MaterialContainer(item);
        return this.removeBlackListedItem(sender, m);
    }

    private boolean removeBlackListedItem(CommandSender sender, MaterialContainer mat) {
        if (mat.isNull()) {
            return false;
        }
        if (!this.itemBlacklist.remove(mat)) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("item", mat.display());
            LocaleHelper.BL_ITEM_NOT_BLISTED.sendLocale(sender, replace);
            return false;
        }
        ExtendedConfiguration config = this.fManager.getYml("blacklist");
        config.set("BlackListedMaterial", this.itemBlacklist);
        try {
            config.save();
        }
        catch (IOException e) {
            DebugLog.INSTANCE.log(Level.WARNING, "Can't save the blacklist", e);
            LocaleHelper.BL_ITEM_PROBLEM.sendLocale(sender);
            return false;
        }
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("material", mat.getMaterial().toString());
        Utils.sI18n(sender, "rmBlacklistItem", replace);
        return true;
    }

    public void removeDisconnectedPlayer(Player player) {
        AFKWorker.getInstance().removePlayer(player);
        this.fakeQuitPlayers.remove(player);
        this.playersForReplyMessage.remove(player);
        this.spyPlayers.remove(player);
        InvisibleWorker.getInstance().onQuitEvent(player);
    }

    public void removeFakeQuit(Player p) {
        this.fakeQuitPlayers.remove(p);
    }

    public void removeReplyPlayer(Player key) {
        if (key == null) {
            return;
        }
        this.playersForReplyMessage.remove(key);
    }

    public void removeSpy(Player p) {
        if (p == null) {
            return;
        }
        this.spyPlayers.remove(p);
    }

    public boolean repairable(int id) {
        return listOfPossibleRepair.contains(id);
    }

    public boolean rmAlias(CommandSender sender, String alias) {
        this.fManager.removeAlias(alias);
        this.alias.remove(alias);
        sender.sendMessage(ChatColor.GOLD + alias + ChatColor.RED + " removed");
        return true;
    }

    public void saveElapsedTime() {
        this.pluginConfig.set("pluginStarted", pluginStarted);
        try {
            this.pluginConfig.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setCoreInstance(AdminCmd pluginInstance) {
        ACPluginManager.setCorePlugin(pluginInstance);
        this.coreInstance = pluginInstance;
        this.fManager = FileManager.getInstance();
        this.fManager.setPath(pluginInstance.getDataFolder().getPath());
        this.dataManager = this.fManager;
        PlayerManager.getInstance().setPlayerFactory(new FilePlayerFactory(this.coreInstance.getDataFolder().getPath() + File.separator + "userData"));
        WorldManager.getInstance().setWorldFactory(new FileWorldFactory(this.coreInstance.getDataFolder().getPath() + File.separator + "worldData"));
        this.convertSpawnWarp();
        this.fManager.getInnerFile("kits.yml");
        this.fManager.getInnerFile("ReadMe.txt", null, true);
        this.fManager.getInnerFile("AdminCmd.yml", "HelpFiles" + File.separator + "AdminCmd", true);
        this.pluginConfig = ExtendedConfiguration.loadConfiguration(new File(this.coreInstance.getDataFolder(), "config.yml"));
        TextLocale.setVersion(ExtendedConfiguration.loadConfiguration(new File(new File(this.coreInstance.getDataFolder(), "locales"), "textFile.yml")));
        ConfigEnum.setPluginInfos(pluginInstance.getDescription());
        ConfigEnum.setConfig(this.pluginConfig);
        this.pluginConfig.options().copyDefaults(true).header(ConfigEnum.getHeader());
        this.pluginConfig.addDefaults(ConfigEnum.getDefaultvalues());
        List<String> disabled = new ArrayList<String>();
        List<String> priority = new ArrayList<String>();
        if (this.pluginConfig.get("disabledCommands") != null) {
            disabled = this.pluginConfig.getStringList("disabledCommands", disabled);
            this.pluginConfig.remove("disabledCommands");
        }
        if (this.pluginConfig.get("prioritizedCommands") != null) {
            priority = this.pluginConfig.getStringList("prioritizedCommands", priority);
            this.pluginConfig.remove("prioritizedCommands");
        }
        if (this.pluginConfig.get("respawnAtSpawnPoint") != null) {
            this.pluginConfig.remove("respawnAtSpawnPoint");
        }
        try {
            this.pluginConfig.save();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!this.pluginConfig.getBoolean("debug")) {
            DebugLog.stopLogging();
        }
        ExtendedConfiguration commands = ExtendedConfiguration.loadConfiguration(new File(this.coreInstance.getDataFolder(), "commands.yml"));
        commands.add("disabledCommands", disabled);
        commands.add("prioritizedCommands", priority.isEmpty() ? Arrays.asList("reload", "/", "stop") : priority);
        ExConfigurationSection aliases = commands.addSection("aliases");
        ExConfigurationSection god = aliases.addSection("god");
        god.add("gg", "");
        god.add("gd", "");
        ExConfigurationSection fly = aliases.addSection("fly");
        fly.add("ofly", "-o");
        ExConfigurationSection egg = aliases.addSection("egg");
        egg.add("grenade", "-E ExplosionEgg");
        try {
            commands.save();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.init();
    }

    public void setReplyPlayer(Player key, Player value) {
        this.playersForReplyMessage.put(key, value);
    }

    public void setServerLocked(boolean serverLocked) {
        this.serverLocked = serverLocked;
    }

    public void setSpawn(CommandSender sender) {
        if (Utils.isPlayer(sender)) {
            final Location loc = ((Player)sender).getLocation();
            final World w = loc.getWorld();
            ACPluginManager.scheduleSyncTask(new Runnable(){

                @Override
                public void run() {
                    w.setSpawnLocation(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
                }
            });
            ACWorld.getWorld(w.getName()).setSpawn(loc);
            Utils.sI18n(sender, "setSpawn");
        }
    }

    public void spawn(Player player) {
        this.spawn(player, null);
    }

    public void spawn(Player player, ACWorld world) {
        Location loc = null;
        if (world == null) {
            String worldName = player.getWorld().getName();
            loc = ACWorld.getWorld(worldName).getSpawn();
        } else {
            loc = world.getSpawn();
        }
        if (loc == null) {
            loc = player.getWorld().getSpawnLocation();
        }
        Utils.teleportWithChunkCheck(player, loc);
    }

    public void unBanPlayer(IBan ban) {
        Lister list;
        this.bannedPlayers.remove(ban.getPlayer());
        this.dataManager.unBanPlayer(ban);
        if (ban instanceof BannedIP) {
            ACPluginManager.getServer().unbanIP(ban.getPlayer());
        }
        if ((list = Lister.getLister(Lister.List.BAN, false)) != null) {
            list.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int undoLastModification(String player) throws EmptyStackException {
        if (!this.undoQueue.containsKey(player)) {
            throw new EmptyStackException();
        }
        Stack blockQueue = (Stack)this.undoQueue.get(player);
        if (blockQueue.isEmpty()) {
            throw new EmptyStackException();
        }
        Stack undo = (Stack)blockQueue.pop();
        Stack<BlockRemanence> undoCache = new Stack<BlockRemanence>();
        int i = 0;
        try {
            while (!undo.isEmpty()) {
                undoCache.push((BlockRemanence)undo.pop());
                if (undoCache.size() == 512) {
                    ACPluginManager.getScheduler().scheduleSyncDelayedTask((Plugin)this.coreInstance, (Runnable)new UndoBlockTask(undoCache), 1L);
                }
                ++i;
            }
        }
        catch (Exception e) {
            ACLogger.severe(e.getMessage(), e);
            int n = i;
            return n;
        }
        finally {
            ACPluginManager.getScheduler().scheduleSyncDelayedTask((Plugin)this.coreInstance, (Runnable)new UndoBlockTask(undoCache), 1L);
        }
        return i;
    }

    static {
        int i;
        instance = new ACHelper();
        materialsColors = new HashMap();
        materialsColors.put(Material.WOOL, new String[]{"White", "Orange", "Magenta", "LightBlue", "Yellow", "LimeGreen", "Pink", "Gray", "LightGray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"});
        materialsColors.put(Material.INK_SACK, new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "LimeGreen", "Yellow", "LightBlue", "Magenta", "Orange", "White"});
        materialsColors.put(Material.LOG, new String[]{"Oak", "Pine", "Birch"});
        materialsColors.put(Material.STEP, new String[]{"Stone", "Sandstone", "Wooden", "Cobblestone"});
        materialsColors.put(Material.DOUBLE_STEP, materialsColors.get(Material.STEP));
        listOfPossibleRepair = new LinkedList<Integer>();
        for (i = 256; i <= 259; ++i) {
            listOfPossibleRepair.add(i);
        }
        for (i = 267; i <= 279; ++i) {
            listOfPossibleRepair.add(i);
        }
        for (i = 283; i <= 286; ++i) {
            listOfPossibleRepair.add(i);
        }
        for (i = 290; i <= 294; ++i) {
            listOfPossibleRepair.add(i);
        }
        for (i = 298; i <= 317; ++i) {
            listOfPossibleRepair.add(i);
        }
        listOfPossibleRepair.add(359);
        listOfPossibleRepair.add(Material.BOW.getId());
        listOfPossibleRepair.add(Material.FISHING_ROD.getId());
    }
}

