/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.World;

import be.Balor.Manager.Exceptions.WorldNotLoaded;
import be.Balor.Tools.Help.String.Str;
import be.Balor.World.ACWorld;
import be.Balor.World.IWorldFactory;
import com.google.common.collect.MapMaker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class WorldManager {
    private final ConcurrentMap<String, ACWorld> worlds = new MapMaker().makeMap();
    private IWorldFactory worldFactory;
    private static WorldManager instance = new WorldManager();

    private WorldManager() {
    }

    public static WorldManager getInstance() {
        return instance;
    }

    private synchronized boolean addWorld(ACWorld world) {
        String name = world.getName();
        if (name == null) {
            throw new NullPointerException();
        }
        ACWorld ref = (ACWorld)this.worlds.get(name);
        if (ref != null) {
            return false;
        }
        this.worlds.put(name, world);
        return true;
    }

    public void setWorldFactory(IWorldFactory worldFactory) {
        if (this.worldFactory == null) {
            this.worldFactory = worldFactory;
        }
    }

    public void convertFactory(IWorldFactory factory) {
        HashMap<String, ACWorld> newWorlds = new HashMap<String, ACWorld>();
        for (Map.Entry entry : this.worlds.entrySet()) {
            ACWorld newWorld = factory.createWorld((String)entry.getKey());
            ACWorld oldWorld = (ACWorld)entry.getValue();
            newWorld.setDifficulty(oldWorld.getDifficulty());
            newWorld.setSpawn(oldWorld.getSpawn());
            for (String string : oldWorld.getMobLimitList()) {
                newWorld.setMobLimit(string, oldWorld.getMobLimit(string));
            }
            for (Map.Entry entry2 : oldWorld.getInformations().entrySet()) {
                newWorld.setInformation((String)entry2.getKey(), oldWorld.getInformation((String)entry2.getKey()).getObj());
            }
            newWorlds.put(newWorld.getName(), newWorld);
        }
        this.worlds.clear();
        this.worlds.putAll(newWorlds);
        this.worldFactory = factory;
    }

    ACWorld demandACWorld(String name) throws WorldNotLoaded {
        ACWorld result = (ACWorld)this.worlds.get(name);
        if (result == null) {
            String found = Str.matchString(this.worlds.keySet(), name);
            if (found != null) {
                return (ACWorld)this.worlds.get(found);
            }
            result = this.worldFactory.createWorld(name);
            this.addWorld(result);
            result = (ACWorld)this.worlds.get(name);
        }
        return result;
    }

    public Set<String> getAllWarpList() {
        HashSet<String> warps = new HashSet<String>();
        for (ACWorld world : this.worlds.values()) {
            for (String warp : world.getWarpList()) {
                warps.add(world.getName() + ":" + warp);
            }
        }
        return warps;
    }
}

