/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum Type {
    FLY(Category.SUPER_POWER),
    FLY_OLD(Category.SUPER_POWER),
    VULCAN(Category.SUPER_POWER),
    GOD(Category.SUPER_POWER),
    THOR(Category.SUPER_POWER),
    BANNED(Category.SANCTION),
    KICKED(Category.SANCTION),
    FIREBALL(Category.SUPER_POWER),
    SPYMSG(Category.OTHER),
    FROZEN(Category.SANCTION),
    MUTED(Category.SANCTION),
    MUTED_COMMAND(Category.SANCTION),
    MOB_LIMIT(Category.WORLD),
    NO_PICKUP(Category.SUPER_POWER),
    WEATHER_FROZEN(Category.WORLD),
    REPEAT_CMD(Category.OTHER),
    TIME_FREEZED(Category.WORLD),
    TP_REQUEST(Category.OTHER),
    TP_AT_SEE(Category.SUPER_POWER),
    SUPER_BREAKER(Category.SUPER_POWER),
    INVISIBLE(Category.SUPER_POWER),
    FAKEQUIT(Category.SUPER_POWER),
    ETERNAL(Category.SUPER_POWER),
    NO_DROP(Category.SUPER_POWER),
    EGG(Category.SUPER_POWER),
    CUSTOM(Category.MISC);

    private static final Map<String, Type> lookupName;
    private final Category category;

    public String toString() {
        String s = super.toString();
        return s.toLowerCase();
    }

    public String display() {
        String s = super.toString();
        return s.substring(0, 1) + s.substring(1).toLowerCase().replaceAll("_", " ");
    }

    private Type(Category category) {
        this.category = category;
    }

    public int id() {
        return this.ordinal() ^ ((Object)((Object)this)).getClass().getName().hashCode();
    }

    public static Type matchType(String name) {
        Type result = null;
        String filtered = name.toUpperCase();
        filtered = filtered.replaceAll("\\s+", "_").replaceAll("\\W", "");
        result = lookupName.get(filtered);
        return result;
    }

    public static void addCustomPower(String name) {
        lookupName.put(name, CUSTOM);
    }

    public Category getCategory() {
        return this.category;
    }

    static {
        lookupName = new HashMap<String, Type>();
        for (Type type : Type.values()) {
            lookupName.put(type.name(), type);
        }
    }

    public static enum Limit {
        IMMUNITY("immunityLvl"),
        MAX_HOME("maxHomeByUser"),
        MAX_ITEMS("maxItemAmount");

        private final String text;

        private Limit(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum Health {
        KILL,
        HEAL,
        FEED;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static enum ArmorPart {
        BOOTS(0, 301),
        LEGS(1, 300),
        CHEST(2, 299),
        HEAD(3, 298);

        private final int placeInInventory;
        private final List<Integer> possibleId = new ArrayList<Integer>();
        private static final int nbEquipment = 5;

        private ArmorPart(int placeInInventory, int firstPossible) {
            this.placeInInventory = placeInInventory;
            for (int i = 0; i < 5; ++i) {
                this.possibleId.add(i * 4 + firstPossible);
            }
        }

        public int getPlaceInInventory() {
            return this.placeInInventory;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        public boolean isValid(int toCheck) {
            return this.possibleId.contains(toCheck);
        }
    }

    public static enum Whois {
        LOGOUT("lastDisconnect"),
        LOGIN("lastConnection");

        private final String val;

        private Whois(String val) {
            this.val = val;
        }

        public String getVal() {
            return this.val;
        }
    }

    public static enum Tp {
        HERE,
        TO,
        PLAYERS;


        public String toString() {
            String s = super.toString();
            return s.toLowerCase().replaceAll("_", " ");
        }
    }

    public static enum Weather {
        STORM,
        RAIN,
        CLEAR,
        FREEZE;

    }

    public static enum Category {
        SUPER_POWER,
        WORLD,
        OTHER,
        SANCTION,
        MISC;

    }
}

