/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Threads;

import be.Balor.Tools.Configuration.File.ExtendedConfiguration;
import be.Balor.Tools.Debug.ACLogger;
import be.Balor.Tools.Debug.DebugLog;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public class IOSaveTask
implements Runnable {
    private final LinkedBlockingQueue<ExtendedConfiguration> configurations = new LinkedBlockingQueue();
    private final Lock lock = new ReentrantLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurationToSave(ExtendedConfiguration ex) {
        this.lock.lock();
        try {
            if (!this.configurations.contains(ex)) {
                this.configurations.add(ex);
                DebugLog.INSTANCE.fine("Added ExtendedConfiguration : " + ex);
            } else {
                DebugLog.INSTANCE.info("ALREADY IN ExtendedConfiguration : " + ex);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConfiguration(ExtendedConfiguration ex) {
        boolean remove = false;
        this.lock.lock();
        try {
            remove = this.configurations.remove(ex);
        }
        finally {
            this.lock.unlock();
        }
        return remove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.lock.lock();
        try {
            DebugLog.INSTANCE.info("Begin Configuration save with " + this.configurations.size() + " file(s)");
            while (!this.configurations.isEmpty()) {
                try {
                    this.configurations.poll().save();
                }
                catch (IOException e) {
                    ACLogger.severe("Problem while saving ExtendedConfiguration file", e);
                    DebugLog.INSTANCE.log(Level.SEVERE, "Problem while saving config files", e);
                }
            }
            DebugLog.INSTANCE.info("All Configuration File saved.");
        }
        finally {
            this.lock.unlock();
        }
    }
}

