/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class MaterialContainer
implements Comparable<MaterialContainer> {
    private Material material = null;
    private short dmg = 0;
    private int amount = 1;
    private final Map<Enchantment, Integer> enchantments;

    public MaterialContainer(ItemStack is) {
        this.material = is.getType();
        this.dmg = is.getDurability();
        this.enchantments = is.getEnchantments();
    }

    public MaterialContainer(String mat) {
        String[] info = new String[2];
        if (mat.contains(":")) {
            info = mat.split(":");
        } else {
            info[0] = mat;
            info[1] = "0";
        }
        this.parseMat(info[0]);
        this.parseDmg(info[1]);
        this.enchantments = new HashMap<Enchantment, Integer>();
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public MaterialContainer(String mat, String damage) {
        this.parseMat(mat);
        this.parseDmg(damage);
        this.enchantments = new HashMap<Enchantment, Integer>();
    }

    public MaterialContainer() {
        this.enchantments = new HashMap<Enchantment, Integer>();
    }

    private void parseMat(String material) {
        Material m = null;
        try {
            int id = Integer.parseInt(material);
            m = Material.getMaterial((int)id);
        }
        catch (NumberFormatException e) {
            m = Material.matchMaterial((String)material);
        }
        this.material = m;
    }

    private void parseDmg(String damage) {
        short d = 0;
        try {
            d = Short.parseShort(damage);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.dmg = d;
    }

    public boolean isNull() {
        return this.material == null;
    }

    public ItemStack getItemStack() {
        ItemStack toReturn = new ItemStack(this.material, this.amount, this.dmg);
        toReturn.addUnsafeEnchantments(this.enchantments);
        return toReturn;
    }

    public String toString() {
        if (this.material != null) {
            return this.material.getId() + ":" + this.dmg;
        }
        return "";
    }

    public String display() {
        if (this.material != null) {
            return this.material + ":" + this.dmg;
        }
        return "";
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getAmount() {
        return this.amount;
    }

    public short getDmg() {
        return this.dmg;
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public void setDmg(short dmg) {
        this.dmg = dmg;
    }

    @Override
    public int compareTo(MaterialContainer o) {
        if (this.material.equals((Object)o.getMaterial())) {
            return this.dmg - o.getDmg();
        }
        return this.material.compareTo((Enum)o.getMaterial());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dmg;
        result = 31 * result + (this.material == null ? 0 : this.material.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaterialContainer)) {
            return false;
        }
        MaterialContainer other = (MaterialContainer)obj;
        if (this.dmg != other.dmg) {
            return false;
        }
        return this.material == other.material;
    }
}

