/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Lister;

import be.Balor.Tools.Help.String.ACMinecraftFontWidthCalculator;
import be.Balor.Tools.Lister.BanLister;
import be.Balor.Tools.Lister.EmptyListException;
import be.Balor.Tools.Lister.MuteLister;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import org.bukkit.ChatColor;

public abstract class Lister {
    private static final Map<List, Lister> lastListed = new EnumMap<List, Lister>(List.class);

    Lister() {
    }

    public static Lister getLister(List type) {
        return Lister.getLister(type, true);
    }

    public static Lister getLister(List type, boolean instanciate) {
        Lister lister = lastListed.get((Object)type);
        if (!instanciate) {
            return lister;
        }
        if (lister == null) {
            switch (type) {
                case BAN: {
                    lister = new BanLister();
                    break;
                }
                case MUTE: {
                    lister = new MuteLister();
                    break;
                }
            }
            lastListed.put(type, lister);
        }
        return lister;
    }

    public synchronized Collection<String> getPage(int page) throws EmptyListException {
        int entryPerPage = ConfigEnum.LISTER_ITEMS.getInt();
        Collection<String> list = this.getList();
        if (list.isEmpty()) {
            throw new EmptyListException();
        }
        int maxPages = (int)Math.ceil((double)list.size() / (double)entryPerPage);
        page = page > maxPages ? maxPages : page;
        int start = (page - 1) * entryPerPage;
        int end = start + entryPerPage > list.size() ? list.size() : start + entryPerPage;
        ArrayList<String> result = new ArrayList<String>();
        result.add(ChatColor.AQUA + ACMinecraftFontWidthCalculator.strPadCenterChat(ChatColor.DARK_GREEN + " " + (Object)((Object)this.getType()) + " (" + page + "/" + maxPages + ") " + ChatColor.AQUA, '='));
        String[] array = list.toArray(new String[0]);
        for (int i = start; i < end; ++i) {
            result.add(array[i]);
        }
        return result;
    }

    public abstract void update();

    abstract Collection<String> getList();

    abstract List getType();

    public static enum List {
        BAN,
        MUTE;

    }
}

