/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Help;

import be.Balor.Tools.Files.YmlFilter;
import be.Balor.Tools.Help.HelpLister;
import be.Balor.Tools.Help.String.Str;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.reader.UnicodeReader;

public class HelpLoader {
    private static Logger HelpLogger = Logger.getLogger("Minecraft");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(File dataFolder) {
        File helpFolder = new File(dataFolder, "HelpFiles");
        if (!helpFolder.exists()) {
            helpFolder.mkdirs();
        } else if (helpFolder.isDirectory()) {
            int count = 0;
            File[] files = YmlFilter.listRecursively(helpFolder, 1);
            String folder = helpFolder.getAbsolutePath() + File.separator;
            if (files == null) {
                return;
            }
            HashMap<String, Integer> filesLoaded = new HashMap<String, Integer>();
            for (File insideFile : files) {
                String fn = insideFile.getAbsolutePath();
                String fileName = fn.length() > folder.length() ? ((fn = fn.substring(folder.length())).contains(File.separator) ? fn.substring(0, fn.indexOf(File.separator)) : insideFile.getName().replaceFirst(".yml$", "")) : insideFile.getName().replaceFirst(".yml$", "");
                Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
                Map root = null;
                FileInputStream input = null;
                try {
                    input = new FileInputStream(insideFile);
                    root = (Map)yaml.load((Reader)new UnicodeReader((InputStream)input));
                    if (root == null || root.isEmpty()) {
                        System.out.println("The file " + fn + " is empty");
                        continue;
                    }
                }
                catch (Exception ex) {
                    String err = Str.getStackStr(ex);
                    String er = ex.getStackTrace()[0].toString();
                    if (err.contains(er)) {
                        err = err.substring(0, err.indexOf(er));
                    }
                    if (err.contains("at")) {
                        err = err.substring(0, err.lastIndexOf("at"));
                        err = err.substring(0, err.lastIndexOf("\n"));
                    }
                    HelpLogger.severe("Error loading " + fn + "\n" + err);
                }
                finally {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException ex) {}
                    }
                }
                if (root == null) continue;
                int num = 0;
                for (String helpKey : root.keySet()) {
                    Map helpNode = (Map)root.get(helpKey);
                    if (!helpNode.containsKey("command")) {
                        HelpLogger.warning("Help entry node \"" + helpKey + "\" is missing a command name in " + fn);
                        continue;
                    }
                    if (!helpNode.containsKey("description")) {
                        HelpLogger.warning("Help entry node \"" + helpKey + "\" is missing a description in " + fn);
                        continue;
                    }
                    String command = helpNode.get("command").toString();
                    String description = "";
                    try {
                        description = helpNode.get("description").toString();
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    String detailedDescription = "";
                    try {
                        detailedDescription = helpNode.get("detailed").toString();
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    String commandName = helpNode.containsKey("cmdname") ? helpNode.get("cmdname").toString() : helpKey;
                    String plugin = helpNode.containsKey("plugin") ? helpNode.get("plugin").toString() : fileName;
                    ArrayList<String> permissions = new ArrayList<String>();
                    if (helpNode.containsKey("permissions")) {
                        if (helpNode.get("permissions") instanceof List) {
                            for (Object permission : (List)helpNode.get("permissions")) {
                                permissions.add(permission.toString());
                            }
                        } else {
                            permissions.add(helpNode.get("permissions").toString());
                        }
                    }
                    HelpLister.getInstance().addHelpEntry(command, description, detailedDescription, plugin, permissions, commandName);
                    ++num;
                    ++count;
                }
                if (filesLoaded.containsKey(fileName)) {
                    filesLoaded.put(fileName, (Integer)filesLoaded.get(fileName) + num);
                    continue;
                }
                filesLoaded.put(fileName, num);
            }
            String loaded = "";
            for (String f : filesLoaded.keySet()) {
                loaded = loaded + String.format("%s(%d), ", f, filesLoaded.get(f));
            }
            if (ConfigEnum.VERBOSE.getBoolean()) {
                HelpLogger.info("[AdminCmd] " + count + " extra help entries loaded" + (loaded.length() > 2 ? " from files: " + loaded.substring(0, loaded.length() - 2) : ""));
            }
        } else {
            HelpLogger.warning("Error: ExtraHelp is a file");
        }
    }
}

