/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Help;

import be.Balor.Tools.Debug.DebugLog;
import be.Balor.Tools.Help.HelpEntry;
import be.Balor.Tools.Help.HelpList;
import be.Balor.Tools.Help.String.ACMinecraftFontWidthCalculator;
import be.Balor.Tools.Help.String.Str;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class HelpLister {
    private static HelpLister instance = null;
    private final HashMap<String, HelpList> plugins = new HashMap();
    private final List<String> noCmds = new ArrayList<String>();

    private HelpLister() {
    }

    public static HelpLister getInstance() {
        if (instance == null) {
            instance = new HelpLister();
        }
        return instance;
    }

    public static void killInstance() {
        instance = null;
    }

    public void addPlugin(Plugin plugin) {
        String pName = plugin.getDescription().getName();
        if (!this.plugins.containsKey(pName) && !this.noCmds.contains(pName)) {
            try {
                this.plugins.put(pName, new HelpList(plugin));
            }
            catch (IllegalArgumentException e) {
                this.noCmds.add(pName);
            }
        }
    }

    public Set<String> getPluginList() {
        return this.plugins.keySet();
    }

    public void addHelpEntry(String command, String description, String detailedDesc, String plugin, List<String> permissions, String cmdName) {
        HelpList help = this.plugins.get(plugin);
        if (help == null) {
            help = new HelpList(plugin);
            this.plugins.put(plugin, help);
        }
        help.addEntry(new HelpEntry(command, description, detailedDesc, permissions, cmdName));
    }

    public boolean removeHelpEntry(String plugin, String commandName) {
        HelpList help = this.plugins.get(plugin);
        if (help == null) {
            DebugLog.INSTANCE.severe("Plugin " + plugin + " not found.");
            return false;
        }
        return help.removeEntry(commandName);
    }

    public boolean sendHelpPage(String plugin, int page, CommandSender sender) {
        HelpList help = this.matchPlugin(plugin);
        if (help == null) {
            return false;
        }
        List<String> toDisplay = help.getPage(page, sender);
        for (String send : toDisplay) {
            for (String l : send.split("\n")) {
                sender.sendMessage(l);
            }
        }
        return true;
    }

    private HelpList matchPlugin(String plugin) {
        HelpList help = this.plugins.get(plugin);
        if (help == null) {
            String keyFound = Str.matchString(this.plugins.keySet(), plugin);
            if (keyFound == null) {
                return null;
            }
            help = this.plugins.get(keyFound);
        }
        return help;
    }

    public boolean sendHelpCmd(String pluginName, String command, CommandSender sender, boolean detailed) {
        List<HelpEntry> chat = null;
        boolean found = false;
        if (pluginName == null) {
            for (HelpList plugin : this.plugins.values()) {
                chat = plugin.getCommandMatch(command, sender);
                if (chat.isEmpty()) continue;
                this.displayHelpMessage(chat, plugin.getPluginName(), sender, detailed);
                found = true;
            }
            return found;
        }
        HelpList plugin = this.matchPlugin(pluginName);
        if (plugin == null) {
            return false;
        }
        chat = plugin.getCommandMatch(command, sender);
        if (chat.isEmpty()) {
            return false;
        }
        this.displayHelpMessage(chat, plugin.getPluginName(), sender, detailed);
        return true;
    }

    public boolean sendHelpCmd(String pluginName, String command, CommandSender sender) {
        return this.sendHelpCmd(pluginName, command, sender, false);
    }

    public boolean displayExactCommandHelp(CommandSender sender, String plugin, String cmdName) {
        HelpList list = this.plugins.get(plugin);
        if (list == null) {
            return false;
        }
        HelpEntry entry = list.getExactCommand(cmdName);
        if (entry == null) {
            return false;
        }
        String chat = entry.chatString(false);
        for (String l : chat.split("\n")) {
            sender.sendMessage(l);
        }
        return true;
    }

    private void displayHelpMessage(List<HelpEntry> list, String pluginName, CommandSender sender, boolean detailed) {
        sender.sendMessage(ChatColor.AQUA + ACMinecraftFontWidthCalculator.strPadCenterChat(ChatColor.DARK_GREEN + " " + pluginName + " " + ChatColor.AQUA, '=') + "\n");
        if (detailed) {
            HelpEntry entry = list.get(0);
            String chat = entry.chatString(detailed);
            for (String l : chat.split("\n")) {
                sender.sendMessage(l);
            }
            return;
        }
        for (HelpEntry entry : list) {
            String chat = entry.chatString(detailed);
            for (String l : chat.split("\n")) {
                sender.sendMessage(l);
            }
        }
    }
}

