/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Files;

import be.Balor.Manager.Permissions.PermissionLinker;
import be.Balor.Tools.MaterialContainer;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.inventory.ItemStack;

public class KitInstance {
    protected final String name;
    protected int delay = 0;
    protected final List<MaterialContainer> items;
    private static final PermissionLinker perm = ACPluginManager.getCorePlugin().getPermissionLinker();

    public KitInstance(String name, int delay, List<MaterialContainer> items) {
        this.name = name;
        this.delay = delay;
        this.items = items;
        perm.addPermChild("admincmd.kit." + this.name);
    }

    public List<ItemStack> getItemStacks() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (MaterialContainer mc : this.items) {
            result.add(mc.getItemStack());
        }
        return result;
    }

    public void addParent(KitInstance parent) {
        for (MaterialContainer mc : parent.items) {
            int index = this.items.indexOf(mc);
            if (index == -1) {
                this.items.add(mc);
                continue;
            }
            MaterialContainer mat = this.items.get(index);
            mat.setAmount(mat.getAmount() + mc.getAmount());
        }
    }

    public int getDelay() {
        return this.delay;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "KitInstance [name=" + this.name + ", delay=" + this.delay + ", items=" + Arrays.toString(this.items.toArray()) + "]";
    }
}

