/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Files;

import au.com.bytecode.opencsv.CSVReader;
import be.Balor.Manager.Exceptions.WorldNotLoaded;
import be.Balor.Player.Ban;
import be.Balor.Player.BannedIP;
import be.Balor.Player.BannedPlayer;
import be.Balor.Player.IBan;
import be.Balor.Tools.Configuration.ExConfigurationSection;
import be.Balor.Tools.Configuration.File.ExtendedConfiguration;
import be.Balor.Tools.Debug.ACLogger;
import be.Balor.Tools.Debug.DebugLog;
import be.Balor.Tools.Exceptions.InvalidInputException;
import be.Balor.Tools.Files.ArmoredKitInstance;
import be.Balor.Tools.Files.DataManager;
import be.Balor.Tools.Files.KitInstance;
import be.Balor.Tools.Files.Unicode.UnicodeReader;
import be.Balor.Tools.Files.Unicode.UnicodeUtil;
import be.Balor.Tools.MaterialContainer;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;

public class FileManager
implements DataManager {
    protected File pathFile;
    private static FileManager instance = null;
    private String lastDirectory = "";
    private String lastFilename = "";
    private File lastFile = null;
    private ExtendedConfiguration lastLoadedConf = null;
    private static String fileVersion = null;

    public static FileManager getInstance() {
        if (instance == null) {
            instance = new FileManager();
        }
        return instance;
    }

    public String getTextFile(String fileName) {
        StringBuffer result = new StringBuffer();
        try {
            String temp;
            File fileDir = this.getInnerFile(fileName);
            BufferedReader in = new BufferedReader(new UnicodeReader(new FileInputStream(fileDir), "UTF-8"));
            while ((temp = in.readLine()) != null) {
                result.append(temp + "\n");
            }
            in.close();
        }
        catch (UnsupportedEncodingException e) {
            ACLogger.Log(Level.SEVERE, e.getMessage(), e);
        }
        catch (IOException e) {
            ACLogger.Log(Level.SEVERE, e.getMessage(), e);
        }
        catch (Exception e) {
            ACLogger.Log(Level.SEVERE, e.getMessage(), e);
        }
        if (result.length() == 0) {
            return null;
        }
        return result.toString().trim();
    }

    public void setPath(String path) {
        this.pathFile = new File(path);
        if (!this.pathFile.exists()) {
            try {
                Files.createParentDirs((File)this.pathFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        File spawn = this.getFile(null, "spawnLocations.yml", false);
        File homeDir = new File(this.pathFile, "home");
        if (spawn.exists()) {
            File dir = new File(this.pathFile, "spawn");
            dir.mkdir();
            spawn.renameTo(new File(dir, "spawnLocations.yml.old"));
        }
        if (homeDir.exists()) {
            homeDir.renameTo(new File(this.pathFile, "userData"));
        }
    }

    public ExtendedConfiguration getYml(String filename, String directory) {
        ExtendedConfiguration config;
        if (this.lastLoadedConf != null && this.lastDirectory.equals(directory == null ? "" : directory) && this.lastFilename.equals(filename)) {
            return this.lastLoadedConf;
        }
        this.lastLoadedConf = config = ExtendedConfiguration.loadConfiguration(this.getFile(directory, filename + ".yml"));
        return config;
    }

    public ExtendedConfiguration getYml(String filename) {
        return this.getYml(filename, null);
    }

    public File getFile(String directory, String filename) {
        return this.getFile(directory, filename, true);
    }

    public File getFile(String directory, String filename, boolean create) {
        if (this.lastFile != null && this.lastDirectory.equals(directory == null ? "" : directory) && this.lastFilename.equals(filename)) {
            return this.lastFile;
        }
        File file = null;
        if (directory != null) {
            File directoryFile = new File(this.pathFile, directory);
            if (!directoryFile.exists() && create) {
                directoryFile.mkdir();
            }
            file = new File(directoryFile, filename);
        } else {
            file = new File(this.pathFile, filename);
        }
        if (!file.exists() && create) {
            try {
                file.createNewFile();
            }
            catch (IOException ex) {
                System.out.println("cannot create file " + file.getPath());
            }
        }
        this.lastFile = file;
        this.lastDirectory = directory == null ? "" : directory;
        this.lastFilename = filename;
        return file;
    }

    public void setTxtFile(String filename, String toSet) {
        File txt = this.getFile(null, filename + ".txt");
        try {
            UnicodeUtil.saveUTF8File(txt, toSet, false);
        }
        catch (IOException e) {
            ACLogger.severe("Can't write the file " + filename, e);
        }
    }

    public void addAlias(String alias, MaterialContainer mc) {
        ExtendedConfiguration conf = this.getYml("Alias");
        List<String> aliasList = conf.getStringList("alias", new ArrayList<String>());
        List<String> idList = conf.getStringList("ids", new ArrayList<String>());
        if (aliasList.contains(alias)) {
            int index = aliasList.indexOf(alias);
            aliasList.remove(index);
            idList.remove(index);
        }
        aliasList.add(alias);
        idList.add(mc.toString());
        conf.set("alias", aliasList);
        conf.set("ids", idList);
        try {
            conf.save();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void removeAlias(String alias) {
        ExtendedConfiguration conf = this.getYml("Alias");
        List<String> aliasList = conf.getStringList("alias", new ArrayList<String>());
        List<String> idList = conf.getStringList("ids", new ArrayList<String>());
        int index = aliasList.indexOf(alias);
        aliasList.remove(index);
        idList.remove(index);
        conf.set("alias", aliasList);
        conf.set("ids", idList);
        try {
            conf.save();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public File getInnerFile(String filename) {
        return this.getInnerFile(filename, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getInnerFile(String filename, String directory, boolean replace) {
        File file;
        if (directory != null) {
            File directoryFile = new File(this.pathFile, directory);
            if (!directoryFile.exists()) {
                directoryFile.mkdirs();
            }
            file = new File(directoryFile, filename);
        } else {
            file = new File(this.pathFile, filename);
        }
        if (file.exists() && replace) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new UnicodeReader(new FileInputStream(file), "UTF-8"));
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            try {
                String version = reader.readLine();
                String versioncheck = version.substring(10);
                if (versioncheck.equals(fileVersion)) {
                    return file;
                }
                reader.close();
                file.delete();
                DebugLog.INSTANCE.info("Delete file : " + file);
            }
            catch (IOException e) {
                file.delete();
            }
            try {
                reader.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!file.exists()) {
            InputStream res = this.getClass().getResourceAsStream("/" + filename);
            Writer tx = null;
            try {
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(UnicodeUtil.UTF8_BOMS);
                tx = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF8"));
                int i = 0;
                while ((i = res.read()) > 0) {
                    tx.write(i);
                }
                tx.flush();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                File file2 = file;
                return file2;
            }
            finally {
                try {
                    res.close();
                }
                catch (Exception ex) {}
                try {
                    if (tx != null) {
                        tx.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
        return file;
    }

    public HashMap<String, MaterialContainer> getAlias() {
        HashMap<String, MaterialContainer> result = new HashMap<String, MaterialContainer>();
        ExtendedConfiguration conf = this.getYml("Alias");
        List<String> aliasList = conf.getStringList("alias", new ArrayList<String>());
        List<String> idList = conf.getStringList("ids", new ArrayList<String>());
        int i = 0;
        try {
            String[] stringArray;
            CSVReader csv = new CSVReader(new FileReader(this.getInnerFile("items.csv", null, true)));
            while ((stringArray = csv.readNext()) != null) {
                try {
                    result.put(stringArray[0], new MaterialContainer(stringArray[1], stringArray[2]));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    try {
                        result.put(stringArray[0], new MaterialContainer(stringArray[1]));
                    }
                    catch (ArrayIndexOutOfBoundsException e2) {}
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String string : aliasList) {
            result.put(string, new MaterialContainer(idList.get(i)));
            ++i;
        }
        return result;
    }

    @Override
    public void writeLocation(Location loc, String name, String filename, String directory) {
        ExtendedConfiguration conf = this.getYml(filename, directory);
        conf.set(name + ".world", loc.getWorld().getName());
        conf.set(name + ".x", loc.getX());
        conf.set(name + ".y", loc.getY());
        conf.set(name + ".z", loc.getZ());
        conf.set(name + ".yaw", Float.valueOf(loc.getYaw()));
        conf.set(name + ".pitch", Float.valueOf(loc.getPitch()));
        try {
            conf.save();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public Location getLocation(String property, String filename, String directory) throws WorldNotLoaded {
        ExtendedConfiguration conf = this.getYml(filename, directory);
        if (conf.get(property + ".world") == null) {
            Location loc = this.parseLocation(property, conf);
            if (loc != null) {
                this.writeLocation(loc, property, filename, directory);
            }
            return loc;
        }
        World w = ACPluginManager.getServer().getWorld(conf.getString(property + ".world"));
        if (w != null) {
            return new Location(w, conf.getDouble(property + ".x", 0.0), conf.getDouble(property + ".y", 0.0), conf.getDouble(property + ".z", 0.0), Float.parseFloat(conf.getString(property + ".yaw")), Float.parseFloat(conf.getString(property + ".pitch")));
        }
        throw new WorldNotLoaded(conf.getString(property + ".world"));
    }

    @Override
    public void removeKey(String property, String filename, String directory) {
        ExtendedConfiguration conf = this.getYml(filename, directory);
        conf.set(property, null);
        try {
            conf.save();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public Set<String> getKeys(String info, String filename, String directory) {
        Set keys = this.getYml(filename, directory).getConfigurationSection(info).getKeys(false);
        if (keys == null) {
            return new HashSet<String>();
        }
        return keys;
    }

    private Location parseLocation(String property, ExtendedConfiguration conf) {
        int i;
        String toParse = conf.getString(property, null);
        if (toParse == null) {
            return null;
        }
        if (toParse.isEmpty()) {
            return null;
        }
        Double[] coords = new Double[3];
        Float[] direction = new Float[2];
        String[] infos = toParse.split(";");
        for (i = 0; i < coords.length; ++i) {
            try {
                coords[i] = Double.parseDouble(infos[i]);
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        for (i = 3; i < infos.length - 1; ++i) {
            try {
                direction[i - 3] = Float.valueOf(Float.parseFloat(infos[i]));
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return new Location(ACPluginManager.getServer().getWorld(infos[5]), coords[0].doubleValue(), coords[1].doubleValue(), coords[2].doubleValue(), direction[0].floatValue(), direction[1].floatValue());
    }

    public Map<String, Object> loadMap(Type type, String directory, String filename) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ExtendedConfiguration conf = this.getYml(filename, directory);
        ExConfigurationSection confSection = conf.getConfigurationSection(type.toString());
        if (confSection != null) {
            for (String key : confSection.getKeys(false)) {
                result.put(key, confSection.get(key));
            }
        }
        return result;
    }

    @Override
    public Map<String, Ban> loadBan() {
        ExConfigurationSection node;
        HashMap<String, Ban> result = new HashMap<String, Ban>();
        ExtendedConfiguration conf = this.getYml("banned");
        if (conf.get("bans") != null) {
            node = conf.getConfigurationSection("bans");
            for (String key : node.getKeys(false)) {
                result.put(key, (BannedPlayer)node.get(key));
            }
        }
        if (conf.get("IPs") != null) {
            node = conf.getConfigurationSection("IPs");
            for (String key : node.getKeys(false)) {
                BannedIP ban = (BannedIP)node.get(key);
                result.put(ban.getPlayer(), ban);
            }
        }
        if (ConfigEnum.IMPORT_BAN_TXT.getBoolean()) {
            this.importBannedPlayerTXT(result);
            ConfigEnum.IMPORT_BAN_TXT.setValue(false);
        }
        return result;
    }

    private void importBannedPlayerTXT(Map<String, Ban> result) {
        Set banned = ACPluginManager.getServer().getBannedPlayers();
        Set ipBanned = ACPluginManager.getServer().getIPBans();
        for (OfflinePlayer op : banned) {
            String name = op.getName();
            if (result.containsKey(name)) continue;
            BannedPlayer bp = new BannedPlayer(name, "Import from banned-players.txt");
            result.put(name, bp);
        }
        for (String ip : ipBanned) {
            if (result.containsKey(ip)) continue;
            result.put(ip, new BannedIP(ip, "Import from banned-ip.txt"));
        }
    }

    public Map<String, KitInstance> loadKits() {
        LinkedHashMap<String, KitInstance> result = new LinkedHashMap<String, KitInstance>();
        ArrayList<MaterialContainer> items = new ArrayList<MaterialContainer>();
        ExtendedConfiguration kits = this.getYml("kits");
        HashMap<String, List> kitParents = new HashMap<String, List>();
        EnumMap<Type.ArmorPart, MaterialContainer> armor = new EnumMap<Type.ArmorPart, MaterialContainer>(Type.ArmorPart.class);
        ExConfigurationSection kitNodes = kits.getConfigurationSection("kits");
        if (kitNodes == null) {
            ACLogger.severe("A problem happen when wanting to load the kits. Please check your kits.yml file.");
            return result;
        }
        for (String string : kitNodes.getKeys(false)) {
            int delay = 0;
            ConfigurationSection kitNode = kitNodes.getConfigurationSection(string);
            ConfigurationSection kitItems = null;
            ConfigurationSection armorItems = null;
            List parents = null;
            try {
                kitItems = kitNode.getConfigurationSection("items");
                armorItems = kitNode.getConfigurationSection("armor");
                parents = kitNode.getStringList("parents");
            }
            catch (NullPointerException e) {
                DebugLog.INSTANCE.warning("Problem with kit " + string);
                continue;
            }
            if (kitItems != null) {
                for (String item : kitItems.getKeys(false)) {
                    try {
                        MaterialContainer m = Utils.checkMaterial(item);
                        m.setAmount(kitItems.getInt(item, 1));
                        if (m.isNull()) continue;
                        items.add(m);
                    }
                    catch (InvalidInputException e) {
                        DebugLog.INSTANCE.log(Level.WARNING, "Problem with kit : " + item, e);
                    }
                }
            }
            delay = kitNode.getInt("delay", 0);
            if (armorItems != null) {
                for (Type.ArmorPart part : Type.ArmorPart.values()) {
                    String partId = armorItems.getString(part.toString());
                    if (partId == null) continue;
                    try {
                        MaterialContainer m = Utils.checkMaterial(partId);
                        if (m.isNull()) continue;
                        armor.put(part, m);
                    }
                    catch (InvalidInputException e) {
                        DebugLog.INSTANCE.log(Level.WARNING, "Problem with kit : " + partId, e);
                    }
                }
                result.put(string, new ArmoredKitInstance(string, delay, new ArrayList<MaterialContainer>(items), new EnumMap<Type.ArmorPart, MaterialContainer>((Map<Type.ArmorPart, MaterialContainer>)armor)));
            } else {
                result.put(string, new KitInstance(string, delay, new ArrayList<MaterialContainer>(items)));
            }
            if (parents != null) {
                kitParents.put(string, parents);
            } else {
                ACLogger.info(string + " has no parents");
            }
            items.clear();
            armor.clear();
        }
        for (Map.Entry entry : kitParents.entrySet()) {
            KitInstance kit = (KitInstance)result.get(entry.getKey());
            for (String parent : (List)entry.getValue()) {
                KitInstance parentKit = (KitInstance)result.get(parent);
                if (parentKit == null) continue;
                if (parentKit instanceof ArmoredKitInstance && !(kit instanceof ArmoredKitInstance)) {
                    kit = new ArmoredKitInstance(kit);
                    result.put(kit.getName(), kit);
                }
                kit.addParent(parentKit);
            }
        }
        return result;
    }

    @Override
    public void addBan(IBan player) {
        ExtendedConfiguration banFile = this.getYml("banned");
        if (player instanceof BannedPlayer) {
            ExConfigurationSection bans = banFile.addSection("bans");
            bans.set(player.getPlayer(), player);
        } else {
            ExConfigurationSection bans = banFile.addSection("IPs");
            bans.set(String.valueOf(player.getPlayer().hashCode()), player);
        }
        try {
            banFile.save();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public void unBanPlayer(IBan ban) {
        String player = ban.getPlayer();
        Matcher ipv4 = Utils.REGEX_IP_V4.matcher(player);
        ExtendedConfiguration banFile = this.getYml("banned");
        if (ipv4.find()) {
            ExConfigurationSection bans = banFile.addSection("IPs");
            bans.set(String.valueOf(player.hashCode()), null);
        } else {
            ExConfigurationSection bans = banFile.addSection("bans");
            bans.set(player, null);
        }
        try {
            banFile.save();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    static {
        try {
            Properties gitVersion = new Properties();
            gitVersion.load(FileManager.class.getResourceAsStream("/git.properties"));
            fileVersion = (String)gitVersion.get("git.commit.id");
            DebugLog.INSTANCE.info("Git Version : " + fileVersion);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

