/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Egg.Types;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Tools.Egg.EggType;
import be.Balor.Tools.Egg.Exceptions.ProcessingArgsException;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerEggThrowEvent;

public class ExplosionEgg
extends EggType<Float> {
    private static final long serialVersionUID = 729116147611485304L;

    @Override
    public void onEvent(PlayerEggThrowEvent event) {
        Egg egg = event.getEgg();
        egg.remove();
        event.setHatching(false);
        egg.getWorld().createExplosion(egg.getLocation(), ((Float)this.value).floatValue());
    }

    @Override
    protected void processArguments(Player sender, CommandArgs args) throws ProcessingArgsException {
        float power = ConfigEnum.DEGG_EX_RADIUS.getFloat();
        if (args.hasFlag('p')) {
            String flag = args.getValueFlag('p');
            try {
                power = Float.parseFloat(flag);
            }
            catch (NumberFormatException e) {
                Utils.sI18n((CommandSender)sender, "NaN", "number", flag);
                return;
            }
        }
        this.value = Float.valueOf(power > ConfigEnum.MAXEGG_EX_RADIUS.getFloat() ? ConfigEnum.MAXEGG_EX_RADIUS.getFloat() : power);
    }
}

