/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Egg.Types;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Tools.Egg.EggType;
import be.Balor.Tools.Egg.EntityInEgg;
import be.Balor.Tools.Egg.Exceptions.ExceptionType;
import be.Balor.Tools.Egg.Exceptions.ParameterMissingException;
import be.Balor.Tools.Egg.Exceptions.ProcessingArgsException;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.LocaleHelper;
import net.minecraft.server.EntityTypes;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerEggThrowEvent;

public class EntityEgg
extends EggType<EntityInEgg> {
    private static final long serialVersionUID = 805828153137593363L;

    @Override
    public void onEvent(PlayerEggThrowEvent event) {
        event.getEgg().remove();
        event.setHatching(false);
        World w = event.getEgg().getWorld();
        Location loc = event.getEgg().getLocation();
        for (int i = 0; i < ((EntityInEgg)this.value).getNb(); ++i) {
            w.spawn(loc, ((EntityInEgg)this.value).getEntityClass());
        }
    }

    @Override
    protected void processArguments(Player sender, CommandArgs args) throws ProcessingArgsException {
        String entityParam = args.getValueFlag('e');
        if (entityParam == null) {
            throw new ParameterMissingException('e', LocaleHelper.EGG_PARAM_ENTITY.getLocale());
        }
        String valFlag = args.getValueFlag('n');
        int nbre = 1;
        int entityNb = 93;
        try {
            entityNb = Integer.parseInt(entityParam);
        }
        catch (NumberFormatException e) {
            Utils.sI18n((CommandSender)sender, "NaN", "number", valFlag);
            return;
        }
        if (args.hasFlag('n')) {
            try {
                nbre = Integer.parseInt(valFlag);
                entityNb = Integer.parseInt(entityParam);
            }
            catch (NumberFormatException e) {
                Utils.sI18n((CommandSender)sender, "NaN", "number", valFlag);
                return;
            }
        }
        try {
            Entity entity = EntityTypes.a((int)entityNb, (net.minecraft.server.World)((CraftWorld)sender.getWorld()).getHandle()).getBukkitEntity();
            this.value = new EntityInEgg(entity.getClass().getName(), nbre, entity.getClass().getSimpleName());
        }
        catch (NullPointerException e) {
            throw new ProcessingArgsException(ExceptionType.DONT_EXISTS, String.valueOf(entityNb));
        }
    }
}

