/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Egg.Types;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Tools.Blocks.BlockRemanence;
import be.Balor.Tools.Blocks.IBlockRemanenceFactory;
import be.Balor.Tools.Egg.BlockChangeInfo;
import be.Balor.Tools.Egg.Exceptions.ExceptionType;
import be.Balor.Tools.Egg.Exceptions.ParameterMissingException;
import be.Balor.Tools.Egg.Exceptions.ProcessingArgsException;
import be.Balor.Tools.Egg.RadiusEgg;
import be.Balor.Tools.MaterialContainer;
import be.Balor.Tools.SimplifiedLocation;
import be.Balor.Tools.SynchronizedStack;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import be.Balor.bukkit.AdminCmd.LocaleHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.plugin.Plugin;

public class BlockEgg
extends RadiusEgg<BlockChangeInfo> {
    private static final long serialVersionUID = 1046757929821301999L;
    private int eggNb = 0;
    private final Map<Integer, SynchronizedStack<BlockRemanence>> blocksPerEvent = Collections.synchronizedMap(new HashMap());

    public BlockEgg() {
        super(ConfigEnum.DEGG_BLOCK_RADIUS.getInt(), ConfigEnum.MAXEGG_BLOCK_RADIUS.getInt());
    }

    public BlockEgg(int defaultRadius, int maxRadius) {
        super(defaultRadius, maxRadius);
    }

    @Override
    public void onEvent(PlayerEggThrowEvent event) {
        int radius = ((BlockChangeInfo)this.value).getRadius() / 2;
        event.getEgg().remove();
        event.setHatching(false);
        Location loc = event.getEgg().getLocation();
        SynchronizedStack<BlockRemanence> blocks = new SynchronizedStack<BlockRemanence>();
        World w = loc.getWorld();
        if (this.blockTimeOut() == 0) {
            for (int x = loc.getBlockX() - radius; x < loc.getBlockX() + radius; ++x) {
                for (int z = loc.getBlockZ() - radius; z < loc.getBlockZ() + radius; ++z) {
                    for (int y = loc.getBlockY() - radius; y < loc.getBlockY() + radius; ++y) {
                        Block block = w.getBlockAt(x, y, z);
                        if (block.getTypeId() != Material.AIR.getId() && block.getTypeId() != Material.SNOW.getId()) continue;
                        IBlockRemanenceFactory.FACTORY.createBlockRemanence(new SimplifiedLocation(w, x, y, z)).setBlockType(((BlockChangeInfo)this.value).getBlockTypeId());
                    }
                }
            }
            return;
        }
        final Integer eventId = this.eggNb++;
        for (int x = loc.getBlockX() - radius; x < loc.getBlockX() + radius; ++x) {
            for (int z = loc.getBlockZ() - radius; z < loc.getBlockZ() + radius; ++z) {
                for (int y = loc.getBlockY() - radius; y < loc.getBlockY() + radius; ++y) {
                    int blckId = w.getBlockTypeIdAt(x, y, z);
                    if (blckId != Material.AIR.getId() && blckId != Material.SNOW.getId()) continue;
                    BlockRemanence blk = IBlockRemanenceFactory.FACTORY.createBlockRemanence(new SimplifiedLocation(w, x, y, z));
                    blk.setBlockType(((BlockChangeInfo)this.value).getBlockTypeId());
                    blocks.add(blk);
                }
            }
        }
        this.blocksPerEvent.put(eventId, blocks);
        ACPluginManager.getScheduler().scheduleSyncDelayedTask((Plugin)ACPluginManager.getCorePlugin(), new Runnable(){

            @Override
            public void run() {
                SynchronizedStack blocks = (SynchronizedStack)BlockEgg.this.blocksPerEvent.get(eventId);
                while (!blocks.empty()) {
                    ((BlockRemanence)blocks.pop()).returnToThePast();
                }
                BlockEgg.this.blocksPerEvent.remove(eventId);
            }
        }, (long)(this.blockTimeOut() * 20));
    }

    protected int blockTimeOut() {
        return ConfigEnum.EGG_BLOCK_TIMEOUT.getInt();
    }

    @Override
    protected void processArguments(Player sender, CommandArgs args) throws ProcessingArgsException {
        String block = args.getValueFlag('b');
        if (block == null) {
            throw new ParameterMissingException('b', LocaleHelper.EGG_PARAM_BLOCK.getLocale());
        }
        int radius = this.getRadius(sender, args);
        if (radius == -1) {
            return;
        }
        MaterialContainer mat = ACHelper.getInstance().checkMaterial((CommandSender)sender, block);
        if (mat.isNull()) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("type", LocaleHelper.TYPE_MAT.getLocale());
            replace.put("value", block);
            throw new ProcessingArgsException(ExceptionType.CUSTOM, LocaleHelper.DONT_EXISTS.getLocale(replace));
        }
        this.value = new BlockChangeInfo(mat.getMaterial().getId(), radius);
    }
}

