/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Egg;

import be.Balor.Manager.Permissions.PermissionLinker;
import be.Balor.Tools.Egg.EggPermission;
import be.Balor.Tools.Egg.EggPermissionManager;
import be.Balor.Tools.Egg.EggType;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;

public class EggTypeClassLoader
extends ClassLoader {
    private static final Map<String, Class<? extends EggType<?>>> classes = new HashMap();
    private static final Map<String, Class<? extends EggType<?>>> classesSimpleName = new HashMap();
    private static final Pattern regex = Pattern.compile("\\w.+Egg");

    public static synchronized void addPackage(Plugin plugin, String packageName) {
        for (Class<?> clazz : EggTypeClassLoader.getClassesInPackage(packageName, plugin.getClass().getClassLoader())) {
            Permission perm = null;
            if (!EggType.class.isAssignableFrom(clazz)) continue;
            if (clazz.isAnnotationPresent(EggPermission.class)) {
                EggPermission annotation = clazz.getAnnotation(EggPermission.class);
                if (!annotation.permission().isEmpty()) {
                    perm = PermissionLinker.addOnTheFly(annotation.permission(), annotation.permissionParent());
                }
            } else {
                String simpleName = clazz.getSimpleName();
                perm = PermissionLinker.addOnTheFly("admincmd.egg." + simpleName.substring(0, simpleName.length() - 3).toLowerCase(), "admincmd.egg.*");
            }
            classes.put(clazz.getName(), clazz);
            classesSimpleName.put(clazz.getSimpleName(), clazz);
            EggPermissionManager.INSTANCE.addPermission(clazz, perm);
        }
    }

    private Class<? extends EggType<?>> matchClassName(String search) throws ClassNotFoundException {
        Class<? extends EggType<?>> found = null;
        String lowerSearch = search.toLowerCase();
        int delta = Integer.MAX_VALUE;
        for (Map.Entry<String, Class<EggType<?>>> entry : classesSimpleName.entrySet()) {
            String str = entry.getKey();
            if (!str.toLowerCase().startsWith(lowerSearch)) continue;
            int curDelta = str.length() - lowerSearch.length();
            if (curDelta < delta) {
                found = entry.getValue();
                delta = curDelta;
            }
            if (curDelta != 0) continue;
            break;
        }
        if (found == null) {
            throw new ClassNotFoundException("Can't find the class " + search);
        }
        return found;
    }

    protected Class<? extends EggType<?>> findClass(String name) throws ClassNotFoundException {
        Class<? extends EggType<?>> clazz = classes.get(name);
        if (clazz == null) {
            clazz = classesSimpleName.get(name);
        }
        if (clazz == null) {
            clazz = this.matchClassName(name);
        }
        if (clazz == null) {
            throw new ClassNotFoundException();
        }
        return clazz;
    }

    private static List<Class<?>> getClassesInPackage(String packageName, ClassLoader classLoader) {
        try {
            assert (classLoader != null);
            String path = packageName.replace('.', '/');
            Enumeration<URL> resources = classLoader.getResources(path);
            ArrayList<String> dirs = new ArrayList<String>();
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                dirs.add(resource.getFile());
            }
            TreeSet<String> classes = new TreeSet<String>();
            for (String directory : dirs) {
                classes.addAll(EggTypeClassLoader.findClasses(directory, packageName));
            }
            ArrayList classList = new ArrayList();
            for (String clazz : classes) {
                classList.add(Class.forName(clazz, true, classLoader));
            }
            return classList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList();
        }
    }

    private static SortedSet<String> findClasses(String path, String packageName) throws Exception {
        File[] files;
        File dir;
        TreeSet<String> classes = new TreeSet<String>();
        if (path.startsWith("file:") && path.contains("!")) {
            ZipEntry entry;
            String[] split = path.split("!");
            URL jar = new URL(split[0]);
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            while ((entry = zip.getNextEntry()) != null) {
                String className;
                if (!entry.getName().endsWith(".class") || !(className = entry.getName().replaceAll("[$].*", "").replaceAll("[.]class", "").replace('/', '.')).startsWith(packageName) || regex != null && !regex.matcher(className).matches()) continue;
                classes.add(className);
            }
        }
        if (!(dir = new File(path)).exists()) {
            return classes;
        }
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(EggTypeClassLoader.findClasses(file.getAbsolutePath(), packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String className = packageName + '.' + file.getName().substring(0, file.getName().length() - 6);
            if (regex != null && !regex.matcher(className).matches()) continue;
            classes.add(className);
        }
        return classes;
    }
}

