/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Configuration.File;

import be.Balor.Tools.TpRequest;
import java.util.LinkedHashMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.CollectionNode;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.representer.SafeRepresenter;

class ExtendedRepresenter
extends Representer {
    public ExtendedRepresenter() {
        this.nullRepresenter = new EmptyRepresentNull();
        this.representers.put(TpRequest.class, new RepresentTpRequest());
        this.multiRepresenters.put(ConfigurationSection.class, new RepresentConfigurationSection());
        this.multiRepresenters.put(ConfigurationSerializable.class, new RepresentConfigurationSerializable());
    }

    protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
        NodeTuple tuple = super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
        Node valueNode = tuple.getValueNode();
        if (valueNode instanceof CollectionNode) {
            SequenceNode seq;
            if (Tag.SEQ.equals((Object)valueNode.getTag()) && (seq = (SequenceNode)valueNode).getValue().isEmpty()) {
                return null;
            }
            if (Tag.MAP.equals((Object)valueNode.getTag()) && (seq = (MappingNode)valueNode).getValue().isEmpty()) {
                return null;
            }
        }
        return tuple;
    }

    private class RepresentTpRequest
    implements Represent {
        private RepresentTpRequest() {
        }

        public Node representData(Object data) {
            TpRequest tpRequest = (TpRequest)data;
            String value = tpRequest.getFrom() + ";" + tpRequest.getTo();
            return ExtendedRepresenter.this.representScalar(new Tag("!tpRequest"), value);
        }
    }

    private class RepresentConfigurationSerializable
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSerializable() {
            super((SafeRepresenter)ExtendedRepresenter.this);
        }

        public Node representData(Object data) {
            ConfigurationSerializable serializable = (ConfigurationSerializable)data;
            LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
            values.put("==", ConfigurationSerialization.getAlias(serializable.getClass()));
            values.putAll(serializable.serialize());
            return super.representData(values);
        }
    }

    private class RepresentConfigurationSection
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSection() {
            super((SafeRepresenter)ExtendedRepresenter.this);
        }

        public Node representData(Object data) {
            return super.representData((Object)((ConfigurationSection)data).getValues(false));
        }
    }

    protected class EmptyRepresentNull
    implements Represent {
        protected EmptyRepresentNull() {
        }

        public Node representData(Object data) {
            return ExtendedRepresenter.this.representScalar(Tag.NULL, "");
        }
    }
}

