/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Configuration.File;

import be.Balor.Tools.Configuration.File.ExFileConfiguration;
import be.Balor.Tools.Configuration.File.ExtendedConfigurationOptions;
import be.Balor.Tools.Configuration.File.ExtendedRepresenter;
import be.Balor.Tools.Configuration.File.YamlConstructor;
import be.Balor.Tools.Debug.ACLogger;
import be.Balor.Tools.Debug.DebugLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.representer.Representer;

public class ExtendedConfiguration
extends ExFileConfiguration {
    protected static final String COMMENT_PREFIX = "# ";
    protected static final String BLANK_CONFIG = "{}\n";
    private static DumperOptions yamlOptions = new DumperOptions();
    private static Representer yamlRepresenter = new ExtendedRepresenter();
    protected static Yaml yaml;

    public static ExtendedConfiguration loadConfiguration(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        ExtendedConfiguration config = new ExtendedConfiguration();
        try {
            config.load(file);
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Cannot load " + file, ex);
        }
        catch (InvalidConfigurationException ex) {
            if (ex.getCause() instanceof YAMLException) {
                ACLogger.severe("Config file " + file + " isn't valid! " + ex.getCause());
            }
            if (ex.getCause() == null || ex.getCause() instanceof ClassCastException) {
                ACLogger.severe("Config file " + file + " isn't valid!");
            }
            ACLogger.severe("Cannot load " + file + ": " + ex.getCause().getClass(), ex);
        }
        return config;
    }

    public static void setClassLoader(ClassLoader loader) {
        yaml = new Yaml((BaseConstructor)new YamlConstructor(loader), yamlRepresenter, yamlOptions);
    }

    @Override
    protected String buildHeader() {
        ExFileConfiguration filedefaults;
        String defaultsHeader;
        Configuration def;
        String header = this.options().header();
        if (this.options().copyHeader() && (def = this.getDefaults()) != null && def instanceof ExFileConfiguration && (defaultsHeader = (filedefaults = (ExFileConfiguration)def).buildHeader()) != null && defaultsHeader.length() > 0) {
            return defaultsHeader;
        }
        if (header == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String[] lines = header.split("\r?\n", -1);
        boolean startedHeader = false;
        for (int i = lines.length - 1; i >= 0; --i) {
            builder.insert(0, "\n");
            if (!startedHeader && lines[i].length() == 0) continue;
            builder.insert(0, lines[i]);
            builder.insert(0, COMMENT_PREFIX);
            startedHeader = true;
        }
        return builder.toString();
    }

    protected void convertMapsToSections(Map<Object, Object> input, ConfigurationSection section) {
        for (Map.Entry<Object, Object> entry : input.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof Map) {
                this.convertMapsToSections((Map)value, section.createSection(key));
                continue;
            }
            section.set(key, value);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void loadFromString(String contents) throws InvalidConfigurationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ExtendedConfigurationOptions options() {
        if (this.options == null) {
            this.options = new ExtendedConfigurationOptions(this);
        }
        return (ExtendedConfigurationOptions)this.options;
    }

    protected String parseHeader(String input) {
        String[] lines = input.split("\r?\n", -1);
        StringBuilder result = new StringBuilder();
        boolean readingHeader = true;
        for (int i = 0; i < lines.length && readingHeader; ++i) {
            String line = lines[i];
            if (line.startsWith(COMMENT_PREFIX)) {
                if (i > 0) {
                    result.append("\n");
                }
                if (line.length() <= COMMENT_PREFIX.length()) continue;
                result.append(line.substring(COMMENT_PREFIX.length()));
                continue;
            }
            if (line.length() == 0) {
                result.append("\n");
                continue;
            }
            readingHeader = false;
        }
        return result.toString();
    }

    public void reload() throws FileNotFoundException, IOException, InvalidConfigurationException {
        this.load(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLineFromFile(int lineToRemove) {
        BufferedReader br = null;
        PrintWriter pw = null;
        try {
            File inFile = this.file;
            File tempFile = File.createTempFile(this.file.getName(), null);
            br = new BufferedReader((Reader)new UnicodeReader((InputStream)new FileInputStream(this.file)));
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "UTF-8"));
            String line = null;
            int i = 0;
            while ((line = br.readLine()) != null) {
                try {
                    if (i == lineToRemove) continue;
                    pw.println(line);
                }
                finally {
                    ++i;
                }
            }
            pw.flush();
            pw.close();
            br.close();
            if (!inFile.delete()) {
                System.out.println("Could not delete file");
                return;
            }
            if (!tempFile.renameTo(inFile)) {
                System.out.println("Could not rename file");
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void save() throws IOException {
        this.save(this.file);
        DebugLog.INSTANCE.info("Saving file : " + this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String saveToString() {
        this.lock.lock();
        String header = "";
        String dump = "";
        try {
            yamlOptions.setIndent(this.options().indent());
            yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            header = this.buildHeader();
            dump = yaml.dump((Object)this.getValues(false));
            if (dump.equals(BLANK_CONFIG)) {
                dump = "";
            }
        }
        finally {
            this.lock.unlock();
        }
        return header + dump;
    }
}

