/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Blocks;

import org.bukkit.Location;
import org.bukkit.block.Block;

public class BlockRemanence {
    protected Location loc;
    private final int oldType;
    private byte data = 0;
    private boolean useData;

    public BlockRemanence(Location loc) {
        this.loc = loc;
        Block b = loc.getWorld().getBlockAt(loc);
        this.oldType = b.getTypeId();
        this.useData = BlockRemanence.usesData(this.oldType);
        if (this.useData) {
            this.data = b.getState().getRawData();
        }
    }

    public Block returnToThePast() {
        Block b = this.loc.getWorld().getBlockAt(this.loc);
        if (this.useData) {
            b.setTypeIdAndData(this.oldType, this.data, true);
        } else {
            b.setTypeId(this.oldType, true);
        }
        return b;
    }

    public void setBlockType(int type) {
        this.loc.getWorld().getBlockAt(this.loc).setTypeId(type, true);
    }

    public int getOldType() {
        return this.oldType;
    }

    public byte getData() {
        return this.data;
    }

    private static boolean usesData(int id) {
        return id == 5 || id == 6 || id == 8 || id == 9 || id == 10 || id == 11 || id == 17 || id == 18 || id == 23 || id == 24 || id == 25 || id == 26 || id == 27 || id == 28 || id == 29 || id == 31 || id == 33 || id == 34 || id == 35 || id == 43 || id == 44 || id == 50 || id == 51 || id == 53 || id == 54 || id == 55 || id == 59 || id == 60 || id == 61 || id == 62 || id == 63 || id == 64 || id == 65 || id == 66 || id == 67 || id == 68 || id == 69 || id == 70 || id == 71 || id == 72 || id == 75 || id == 76 || id == 77 || id == 78 || id == 81 || id == 83 || id == 84 || id == 86 || id == 91 || id == 92 || id == 93 || id == 94 || id == 96 || id == 97 || id == 98 || id == 99 || id == 100 || id == 104 || id == 105 || id == 106 || id == 107 || id == 108 || id == 109 || id == 114 || id == 115 || id == 116 || id == 117 || id == 118 || id == 119 || id == 120 || id == 125 || id == 126 || id == 128 || id == 130;
    }
}

