/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.OpenInv;

import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.OpenInv.ACOfflinePlayerInventory;
import be.Balor.OpenInv.ACPlayerInventory;
import be.Balor.Tools.Debug.DebugLog;
import be.Balor.Tools.Utils;
import be.Balor.World.ACWorld;
import com.google.common.collect.MapMaker;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.IInventory;
import net.minecraft.server.ItemInWorldManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerInventory;
import net.minecraft.server.World;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftInventoryPlayer;
import org.bukkit.entity.Player;

public class InventoryManager {
    public static InventoryManager INSTANCE;
    private final Map<Player, ACPlayerInventory> replacedInv = new MapMaker().makeMap();
    private final Map<String, ACPlayerInventory> offlineInv = new MapMaker().makeMap();

    private InventoryManager() {
    }

    public static void createInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InventoryManager();
        }
    }

    public void onQuit(Player p) {
        this.replacedInv.remove(p);
    }

    void closeOfflineInv(Player p) {
        this.onQuit(p);
        this.offlineInv.remove(p.getName());
        p.saveData();
        DebugLog.INSTANCE.info("Saving Offline Inventory of " + p.getName());
    }

    public void onJoin(Player p) {
        ACPlayerInventory inv = this.offlineInv.get(p.getName());
        if (inv == null) {
            return;
        }
        if (inv instanceof ACOfflinePlayerInventory) {
            CraftPlayer cp = (CraftPlayer)p;
            PlayerInventory mcInv = ((CraftInventoryPlayer)cp.getInventory()).getInventory();
            mcInv.items = inv.items;
            mcInv.armor = inv.armor;
        }
    }

    public void openOfflineInv(Player sender, String name, String world) throws PlayerNotFound {
        CraftPlayer target = null;
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("player", name);
        ACWorld acworld = ACWorld.getWorld(world);
        File playerfolder = new File(acworld.getHandler().getWorldFolder(), "players");
        if (!playerfolder.exists()) {
            throw new PlayerNotFound(Utils.I18n("playerNotFound", replace), (CommandSender)sender);
        }
        String playername = this.matchUser(Arrays.asList(playerfolder.listFiles()), name);
        if (playername == null) {
            throw new PlayerNotFound(Utils.I18n("playerNotFound", replace), (CommandSender)sender);
        }
        MinecraftServer server = ((CraftServer)Bukkit.getServer()).getServer();
        EntityPlayer entity = new EntityPlayer(server, (World)server.getWorldServer(0), playername, new ItemInWorldManager(server.getWorldServer(0)));
        CraftPlayer craftPlayer = target = entity == null ? null : entity.getBukkitEntity();
        if (target == null) {
            throw new PlayerNotFound(Utils.I18n("playerNotFound", replace), (CommandSender)sender);
        }
        target.loadData();
        if (Utils.checkImmunity((CommandSender)sender, (Player)target)) {
            this.openInv(sender, (Player)target, true);
        } else {
            Utils.sI18n((CommandSender)sender, "insufficientLvl");
        }
    }

    public void openInv(Player sender, Player target) {
        this.openInv(sender, target, false);
    }

    private void openInv(Player sender, Player target, boolean offline) {
        ACPlayerInventory inventory = this.getInventory(target, offline);
        EntityPlayer eh = ((CraftPlayer)sender).getHandle();
        eh.openContainer((IInventory)inventory);
    }

    private ACPlayerInventory getInventory(Player player, boolean offline) {
        ACPlayerInventory inventory = this.replacedInv.get(player);
        if (inventory == null) {
            if (offline) {
                inventory = new ACOfflinePlayerInventory(player);
                this.offlineInv.put(player.getName(), inventory);
            } else {
                inventory = new ACPlayerInventory(player);
            }
        }
        return inventory;
    }

    private String matchUser(Collection<File> container, String search) {
        String found = null;
        if (search == null) {
            return found;
        }
        String lowerSearch = search.toLowerCase();
        int delta = Integer.MAX_VALUE;
        for (File file : container) {
            String filename = file.getName();
            String str = filename.substring(0, filename.length() - 4);
            if (!str.toLowerCase().startsWith(lowerSearch)) continue;
            int curDelta = str.length() - lowerSearch.length();
            if (curDelta < delta) {
                found = str;
                delta = curDelta;
            }
            if (curDelta != 0) continue;
            break;
        }
        return found;
    }
}

