/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Terminal;

import be.Balor.Manager.Exceptions.CommandNotFound;
import be.Balor.Manager.Permissions.PermissionLinker;
import be.Balor.Manager.Terminal.Commands.UnixTerminalCommand;
import be.Balor.Manager.Terminal.Commands.WindowsTerminalCommand;
import be.Balor.Manager.Terminal.TerminalCommand;
import be.Balor.Tools.Configuration.File.ExtendedConfiguration;
import be.Balor.Tools.Files.FileManager;
import be.Balor.bukkit.AdminCmd.AbstractAdminCmdPlugin;
import java.io.File;
import java.util.HashMap;
import java.util.Set;
import org.bukkit.command.CommandSender;

public class TerminalCommandManager {
    HashMap<String, TerminalCommand> commands = new HashMap();
    private static TerminalCommandManager instance = null;
    private PermissionLinker perm;

    private TerminalCommandManager() {
    }

    public static TerminalCommandManager getInstance() {
        if (instance == null) {
            instance = new TerminalCommandManager();
        }
        return instance;
    }

    public void setPerm(AbstractAdminCmdPlugin plugin) {
        this.perm = plugin.getPermissionLinker();
        File scripts = FileManager.getInstance().getInnerFile("scripts.yml", "scripts", false);
        File workingDir = scripts.getParentFile();
        ExtendedConfiguration conf = ExtendedConfiguration.loadConfiguration(scripts);
        if (System.getProperty("os.name").contains("Windows")) {
            for (String cmdName : conf.getKeys(false)) {
                WindowsTerminalCommand toAdd = new WindowsTerminalCommand(cmdName, conf.getString(cmdName + ".exec"), conf.getString(cmdName + ".args"), workingDir);
                toAdd.setBukkitPerm(this.perm.addPermChild("admincmd.server.exec." + cmdName));
                this.commands.put(cmdName, toAdd);
            }
        } else {
            for (String cmdName : conf.getKeys(false)) {
                UnixTerminalCommand toAdd = new UnixTerminalCommand(cmdName, conf.getString(cmdName + ".exec"), conf.getString(cmdName + ".args"), workingDir);
                toAdd.setBukkitPerm(this.perm.addPermChild("admincmd.server.exec." + cmdName));
                this.commands.put(cmdName, toAdd);
            }
        }
    }

    public boolean checkCommand(String cmdName, CommandSender sender) {
        TerminalCommand cmd = this.commands.get(cmdName);
        if (cmd == null) {
            return false;
        }
        return cmd.permCheck(sender, false);
    }

    public void reloadScripts() {
        File scripts = FileManager.getInstance().getInnerFile("scripts.yml", "scripts", false);
        File workingDir = scripts.getParentFile();
        ExtendedConfiguration conf = ExtendedConfiguration.loadConfiguration(scripts);
        this.commands.clear();
        if (System.getProperty("os.name").contains("Windows")) {
            for (String cmdName : conf.getKeys(false)) {
                WindowsTerminalCommand toAdd = new WindowsTerminalCommand(cmdName, conf.getString(cmdName + ".exec"), conf.getString(cmdName + ".args"), workingDir);
                toAdd.setBukkitPerm(PermissionLinker.addOnTheFly("admincmd.server.exec." + cmdName, "admincmd.server.exec.*"));
                this.commands.put(cmdName, toAdd);
            }
        } else {
            for (String cmdName : conf.getKeys(false)) {
                UnixTerminalCommand toAdd = new UnixTerminalCommand(cmdName, conf.getString(cmdName + ".exec"), conf.getString(cmdName + ".args"), workingDir);
                toAdd.setBukkitPerm(PermissionLinker.addOnTheFly("admincmd.server.exec." + cmdName, "admincmd.server.exec.*"));
                this.commands.put(cmdName, toAdd);
            }
        }
    }

    public boolean execute(CommandSender sender, String cmdName, boolean reload) throws CommandNotFound {
        TerminalCommand cmd = this.commands.get(cmdName);
        if (cmd == null || reload) {
            File scripts = FileManager.getInstance().getInnerFile("scripts.yml", "scripts", false);
            File workingDir = scripts.getParentFile();
            ExtendedConfiguration conf = ExtendedConfiguration.loadConfiguration(scripts);
            if (conf.get(cmdName) == null) {
                throw new CommandNotFound(cmdName + " is not registered");
            }
            if (System.getProperty("os.name").contains("Windows")) {
                this.commands.put(cmdName, new WindowsTerminalCommand(cmdName, conf.getString(cmdName + ".exec"), conf.getString(cmdName + ".args"), workingDir));
                cmd = this.commands.get(cmdName);
                cmd.setBukkitPerm(PermissionLinker.addOnTheFly("admincmd.server.exec." + cmdName, "admincmd.server.exec.*"));
            } else {
                this.commands.put(cmdName, new UnixTerminalCommand(cmdName, conf.getString(cmdName + ".exec"), conf.getString(cmdName + ".args"), workingDir));
                cmd = this.commands.get(cmdName);
                cmd.setBukkitPerm(PermissionLinker.addOnTheFly("admincmd.server.exec." + cmdName, "admincmd.server.exec.*"));
            }
        }
        if (!cmd.permCheck(sender, true)) {
            return false;
        }
        cmd.execute(sender);
        return true;
    }

    public final Set<String> getCommandList() {
        return this.commands.keySet();
    }
}

