/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Permissions.Plugins;

import be.Balor.Manager.Exceptions.NoPermissionsPlugin;
import be.Balor.Manager.Permissions.Group;
import be.Balor.Manager.Permissions.Plugins.SuperPermissions;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Debug.DebugLog;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionUser;

public class PermissionsEx
extends SuperPermissions {
    private final PermissionManager PEX;

    public PermissionsEx(PermissionManager PEX) {
        this.PEX = PEX;
    }

    @Override
    public boolean hasPerm(CommandSender player, String perm, boolean errorMsg) {
        if (!(player instanceof Player)) {
            return true;
        }
        if (this.PEX.has((Player)player, perm)) {
            return true;
        }
        if (errorMsg) {
            Utils.sI18n(player, "errorNotPerm", "p", perm);
        }
        return false;
    }

    @Override
    public Set<Player> getUsers(String groupName) throws NoPermissionsPlugin {
        PermissionUser[] users = null;
        users = this.PEX.getUsers(groupName);
        HashSet<Player> players = new HashSet<Player>();
        if (users != null) {
            Player player = null;
            for (PermissionUser user : users) {
                player = ACPlayer.getPlayer(user.getName()).getHandler();
                if (player == null) continue;
                players.add(player);
            }
            return players;
        }
        return null;
    }

    @Override
    public String getPermissionLimit(final Player p, final String limit) {
        String permLimit = null;
        try {
            permLimit = this.PEX.getUser(p).getOption("admincmd." + limit);
        }
        catch (ConcurrentModificationException e) {
            final CountDownLatch countDown = new CountDownLatch(1);
            final String[] limitString = new String[1];
            ACPluginManager.scheduleSyncTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        limitString[0] = PermissionsEx.this.PEX.getUser(p).getOption("admincmd." + limit);
                    }
                    catch (Exception e2) {
                        DebugLog.INSTANCE.log(Level.SEVERE, "Cant' get the limit " + limit + " for the user " + p.getName(), e2);
                    }
                    countDown.countDown();
                }
            });
            try {
                countDown.await();
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            permLimit = limitString[0];
        }
        if (permLimit == null || permLimit != null && permLimit.isEmpty()) {
            permLimit = super.getPermissionLimit(p, limit);
        }
        return permLimit;
    }

    @Override
    public String getPrefix(Player player) {
        PermissionGroup group;
        PermissionUser user = null;
        try {
            user = this.PEX.getUser(player);
        }
        catch (Exception e) {
            DebugLog.INSTANCE.log(Level.SEVERE, "Problem when trying to get the prefix of the user " + player.getName(), e);
            return "";
        }
        if (user != null) {
            return user.getPrefix() == null ? "" : user.getPrefix();
        }
        String prefix = "";
        PermissionGroup[] arr$ = this.PEX.getUser(player).getGroups();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && ((prefix = (group = arr$[i$]).getPrefix()) == null || prefix.isEmpty()); ++i$) {
        }
        return prefix;
    }

    @Override
    public String getSuffix(Player player) {
        PermissionGroup group;
        PermissionUser user = this.PEX.getUser(player);
        if (user != null) {
            return user.getSuffix() == null ? "" : user.getSuffix();
        }
        String suffix = "";
        PermissionGroup[] arr$ = this.PEX.getUser(player).getGroups();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && ((suffix = (group = arr$[i$]).getSuffix()) == null || suffix.isEmpty()); ++i$) {
        }
        return suffix;
    }

    @Override
    public Group getGroup(Player player) {
        int max = Integer.MIN_VALUE;
        PermissionGroup cur = null;
        for (PermissionGroup group : this.PEX.getUser(player).getGroups()) {
            int rank = group.getRank();
            if (rank <= max) continue;
            max = rank;
            cur = group;
        }
        if (cur == null) {
            return new Group();
        }
        return new Group(cur.getName(), cur.getRank());
    }
}

