/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Permissions;

import be.Balor.Tools.Type;
import be.Balor.bukkit.AdminCmd.ACHelper;
import org.bukkit.entity.Player;

public class Group
implements Comparable<Group> {
    private final String name;
    private final int rank;

    public Group(String name, int rank) {
        this.name = name;
        this.rank = rank;
    }

    public Group(String name, Player p) {
        this(name, ACHelper.getInstance().getLimit(p, Type.Limit.IMMUNITY, "defaultImmunityLvl"));
    }

    public Group() {
        this("", 0);
    }

    @Override
    public int compareTo(Group o) {
        if (this.rank == o.rank) {
            return this.name.compareTo(o.name);
        }
        return (this.rank - o.rank) * -1;
    }

    public String getName() {
        return this.name;
    }

    public int getRank() {
        return this.rank;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.rank;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.rank == other.rank;
    }

    public String toString() {
        return "Group [name=" + this.name + ", rank=" + this.rank + "]";
    }
}

