/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Warp;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Warp.WarpCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Manager.Permissions.PermChild;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Tools.Utils;
import be.Balor.World.ACWorld;
import be.Balor.World.WorldManager;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WarpList
extends WarpCommand {
    private PermChild tpAll;

    public WarpList() {
        this.permNode = "admincmd.warp.tp";
        this.cmdName = "bal_warplist";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        if (Utils.isPlayer(sender)) {
            Set<String> wp;
            Player p = (Player)sender;
            String msg = "";
            if (args.hasFlag('a')) {
                if (!PermissionManager.hasPerm(sender, this.tpAll.getBukkitPerm())) {
                    return;
                }
                wp = WorldManager.getInstance().getAllWarpList();
            } else {
                wp = ACWorld.getWorld(p.getWorld().getName()).getWarpList();
            }
            sender.sendMessage(ChatColor.GOLD + "Warp Point(s) : " + ChatColor.WHITE + wp.size());
            for (String name : wp) {
                if ((msg = msg + name + ", ").length() < 318) continue;
                sender.sendMessage(msg);
                msg = "";
            }
            if (!msg.equals("")) {
                if (msg.endsWith(", ")) {
                    msg = msg.substring(0, msg.lastIndexOf(","));
                }
                sender.sendMessage(msg);
            }
        }
    }

    @Override
    public void registerBukkitPerm() {
        super.registerBukkitPerm();
        this.tpAll = new PermChild("admincmd.warp.tp.all", this.bukkitDefault);
        this.permParent.addChild(this.tpAll);
    }

    @Override
    public boolean argsCheck(String ... args) {
        return true;
    }
}

