/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Warp;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Warp.WarpCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Exceptions.WorldNotLoaded;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Manager.Permissions.PermChild;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Tools.Utils;
import be.Balor.Tools.Warp;
import be.Balor.World.ACWorld;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TpToWarp
extends WarpCommand {
    private PermChild tpAll;

    public TpToWarp() {
        this.permNode = "admincmd.warp.tp";
        this.cmdName = "bal_tpwarp";
        this.other = true;
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        Player target = Utils.getUser(sender, args, this.permNode, 1, true);
        if (Utils.isPlayer(sender)) {
            Player p = (Player)sender;
            Location loc = null;
            if (target != null) {
                HashMap<String, String> replace = new HashMap<String, String>();
                if (args.getString(0).contains(":")) {
                    if (!PermissionManager.hasPerm(sender, this.tpAll.getBukkitPerm())) {
                        return;
                    }
                    String[] split = args.getString(0).split(":");
                    String world = split[0];
                    String warp = split[1];
                    replace.put("name", world + ":" + warp);
                    try {
                        ACWorld acWorld = ACWorld.getWorld(world);
                        Warp warpPoint = acWorld.getWarp(warp);
                        if (warpPoint == null) {
                            replace.put("name", args.getString(0));
                            Utils.sI18n(sender, "errorWarp", replace);
                            return;
                        }
                        loc = warpPoint.loc;
                        replace.put("name", acWorld.getName() + ":" + warpPoint.name);
                    }
                    catch (WorldNotLoaded e) {
                        Utils.sI18n(sender, "worldNotFound", "world", world);
                        return;
                    }
                }
                replace.put("name", args.getString(0));
                try {
                    Warp warpPoint = ACWorld.getWorld(p.getWorld().getName()).getWarp(args.getString(0));
                    if (warpPoint == null) {
                        replace.put("name", args.getString(0));
                        Utils.sI18n(sender, "errorWarp", replace);
                        return;
                    }
                    loc = warpPoint.loc;
                    replace.put("name", warpPoint.name);
                }
                catch (WorldNotLoaded e) {
                    // empty catch block
                }
                if (loc == null) {
                    Utils.sI18n(sender, "errorWarp", replace);
                    return;
                }
                ACPluginManager.getScheduler().scheduleSyncDelayedTask((Plugin)ACHelper.getInstance().getCoreInstance(), (Runnable)new DelayedTeleport(target.getLocation(), loc, target, replace, sender), ConfigEnum.TP_DELAY.getLong());
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null && args.length >= 1;
    }

    @Override
    public void registerBukkitPerm() {
        super.registerBukkitPerm();
        this.tpAll = new PermChild("admincmd.warp.tp.all", this.bukkitDefault);
        this.permParent.addChild(this.tpAll);
    }

    private class DelayedTeleport
    implements Runnable {
        protected Location locBefore;
        protected Location teleportToLoc;
        protected Player target;
        protected HashMap<String, String> replace;
        protected CommandSender sender;

        public DelayedTeleport(Location locBefore, Location teleportLoc, Player target, HashMap<String, String> replace, CommandSender sender) {
            this.target = target;
            this.locBefore = locBefore;
            this.teleportToLoc = teleportLoc;
            this.replace = replace;
            this.sender = sender;
        }

        @Override
        public void run() {
            if (this.locBefore.equals((Object)this.target.getLocation()) && ConfigEnum.CHECKTP.getBoolean()) {
                Utils.teleportWithChunkCheck(this.target, this.teleportToLoc);
                Utils.sendMessage(this.sender, (CommandSender)this.target, "tpWarp", this.replace);
            } else if (!ConfigEnum.CHECKTP.getBoolean()) {
                Utils.teleportWithChunkCheck(this.target, this.teleportToLoc);
                Utils.sendMessage(this.sender, (CommandSender)this.target, "tpWarp", this.replace);
            } else {
                this.replace.clear();
                this.replace.put("cmdname", "Warp");
                Utils.sendMessage(this.sender, (CommandSender)this.target, "errorMoved", this.replace);
            }
        }
    }
}

