/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Tp;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Tp.TeleportCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Manager.Permissions.PermChild;
import be.Balor.Manager.Permissions.PermParent;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Tools.Threads.TeleportTask;
import be.Balor.Tools.Utils;
import be.Balor.World.ACWorld;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.LocaleHelper;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TpWorld
extends TeleportCommand {
    private final PermChild list;

    public TpWorld() {
        this.permNode = "admincmd.tp.world";
        this.cmdName = "bal_tpworld";
        this.other = true;
        this.list = new PermChild(this.permNode + ".list");
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws PlayerNotFound, ActionNotPermitedException {
        Player target = Utils.getUserParam(sender, args, this.permNode);
        assert (target != null);
        HashMap<String, String> replace = new HashMap<String, String>();
        if (args.length < 1) {
            if (PermissionManager.hasPerm((CommandSender)target, this.permNode + ".list")) {
                List worlds = ACPluginManager.getServer().getWorlds();
                String worldList = "";
                for (World w : worlds) {
                    worldList = worldList + w.getName() + ", ";
                }
                worldList = worldList.substring(0, worldList.length() - 2);
                replace.put("list", worldList);
                LocaleHelper.TP_DIM_LIST.sendLocale((CommandSender)target, replace);
            }
            return;
        }
        if (args.hasFlag('l')) {
            return;
        }
        String worldName = args.getString(0);
        if (worldName == null || worldName == "") {
            replace.put("arg", "world");
            replace.put("cmdName", "/tpd");
            LocaleHelper.MISSING_ARG.sendLocale(sender, replace);
            return;
        }
        ACWorld world = ACWorld.getWorld(worldName);
        Location loc = world.getSpawn();
        if (loc == null) {
            return;
        }
        ACPluginManager.scheduleSyncTask(new TeleportTask(target, loc));
        replace.put("world", worldName);
        LocaleHelper.TP_DIM.sendLocale((CommandSender)target, replace);
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }

    @Override
    public void registerBukkitPerm() {
        PermParent parent = new PermParent(this.permNode + ".*");
        this.plugin.getPermissionLinker().addChildPermParent(parent, this.permParent);
        PermChild child = new PermChild(this.permNode, this.bukkitDefault);
        parent.addChild(child).addChild(this.list);
        this.bukkitPerm = child.getBukkitPerm();
    }
}

