/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Tp;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Tp.TeleportCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Manager.Permissions.PermParent;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.TpRequest;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TpToggle
extends TeleportCommand {
    public TpToggle() {
        this.cmdName = "bal_tptoggle";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        if (Utils.isPlayer(sender)) {
            Player player = (Player)sender;
            ACPlayer acp = ACPlayer.getPlayer(player.getName());
            if (args.length >= 1 && acp.hasPower(Type.TP_REQUEST) && args.getString(0).equalsIgnoreCase("yes")) {
                if (!PermissionManager.hasPerm((CommandSender)player, "admincmd.tp.toggle.allow")) {
                    return;
                }
                TpRequest request = acp.getTpRequest();
                if (request != null) {
                    request.teleport(player);
                    acp.removeTpRequest();
                } else {
                    Utils.sI18n(sender, "noTpRequest");
                }
            } else {
                if (!PermissionManager.hasPerm((CommandSender)player, "admincmd.tp.toggle.use")) {
                    return;
                }
                if (acp.hasPower(Type.TP_REQUEST)) {
                    acp.removePower(Type.TP_REQUEST);
                    Utils.sI18n((CommandSender)player, "tpRequestOff");
                } else {
                    acp.setPower(Type.TP_REQUEST);
                    Utils.sI18n((CommandSender)player, "tpRequestOn");
                }
            }
        }
    }

    @Override
    public void registerBukkitPerm() {
        PermParent parent = this.plugin.getPermissionLinker().getPermParent("admincmd.tp.toggle.*");
        parent.addChild("admincmd.tp.toggle.allow").addChild("admincmd.tp.toggle.use");
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }
}

