/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Spawn;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Spawn.SpawnCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Tools.SimplifiedLocation;
import be.Balor.Tools.Utils;
import be.Balor.World.ACWorld;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Spawn
extends SpawnCommand {
    public Spawn() {
        this.permNode = "admincmd.spawn.tp";
        this.cmdName = "bal_spawn";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        if (args.length >= 1 && Utils.isPlayer(sender, true)) {
            ACWorld w = ACWorld.getWorld(args.getString(0));
            Player target = (Player)sender;
            ACPluginManager.getScheduler().scheduleSyncDelayedTask((Plugin)ACHelper.getInstance().getCoreInstance(), (Runnable)new DelayedTeleport(target, sender, w), ConfigEnum.TP_DELAY.getLong());
        } else if (Utils.isPlayer(sender, true)) {
            Player target = (Player)sender;
            ACPluginManager.getScheduler().scheduleSyncDelayedTask((Plugin)ACHelper.getInstance().getCoreInstance(), (Runnable)new DelayedTeleport(target, sender, null), ConfigEnum.TP_DELAY.getLong());
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }

    private class DelayedTeleport
    implements Runnable {
        protected SimplifiedLocation locBefore;
        protected Player target;
        protected HashMap<String, String> replace;
        protected CommandSender sender;
        protected ACWorld world;

        public DelayedTeleport(Player target, CommandSender sender, ACWorld world) {
            this.target = target;
            this.locBefore = new SimplifiedLocation(target.getLocation());
            this.sender = sender;
            this.world = world;
        }

        @Override
        public void run() {
            if (!ConfigEnum.CHECKTP.getBoolean()) {
                ACHelper.getInstance().spawn((Player)this.sender, this.world);
                Utils.sendMessage(this.sender, (CommandSender)this.target, "spawn");
                return;
            }
            if (this.locBefore.equals(this.target.getLocation())) {
                ACHelper.getInstance().spawn((Player)this.sender, this.world);
                Utils.sendMessage(this.sender, (CommandSender)this.target, "spawn");
            } else {
                this.replace = new HashMap();
                this.replace.put("cmdname", "Warp");
                Utils.sendMessage(this.sender, (CommandSender)this.target, "errorMoved", this.replace);
            }
        }
    }
}

