/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Server;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Server.ServerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class StopServer
extends ServerCommand {
    public StopServer() {
        this.permNode = "admincmd.server.stop";
        this.cmdName = "bal_stop";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        int timeOutValue;
        String timeOut = args.getValueFlag('t');
        if (timeOut != null) {
            try {
                timeOutValue = Integer.parseInt(timeOut);
            }
            catch (Exception e) {
                Utils.sI18n(sender, "NaN", "number", timeOut);
                return;
            }
        } else {
            timeOutValue = ConfigEnum.TIME_STOP.getInt();
        }
        Utils.broadcastMessage(Utils.I18n("serverWillStop", "sec", String.valueOf(timeOutValue)));
        ACHelper.getInstance().setServerLocked(true);
        final List<Player> onlinePlayers = Utils.getOnlinePlayers();
        ACPluginManager.getScheduler().scheduleSyncDelayedTask((Plugin)ACPluginManager.getCorePlugin(), new Runnable(){

            @Override
            public void run() {
                for (Player p : onlinePlayers) {
                    p.kickPlayer(Utils.I18n("serverStop"));
                }
                Bukkit.getServer().shutdown();
            }
        }, (long)(20 * timeOutValue));
    }

    @Override
    public boolean argsCheck(String ... args) {
        return true;
    }
}

