/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Server;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Server.ServerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Manager.Permissions.PermChild;
import be.Balor.Manager.Permissions.PermParent;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Semaphore;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityAnimal;
import net.minecraft.server.EntityBoat;
import net.minecraft.server.EntityExperienceOrb;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityMinecart;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.EntityPainting;
import net.minecraft.server.EntityVillager;
import net.minecraft.server.WorldServer;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.plugin.Plugin;

public class Memory
extends ServerCommand {
    private final PermChild full;
    private final PermChild animal;
    private final PermChild xp;
    private final PermChild item;
    private final PermChild mob;
    private final PermChild npc;
    private final PermChild cart;
    private final PermChild boat;
    private final PermChild vehicle;

    public Memory() {
        this.permNode = "admincmd.server.memory";
        this.cmdName = "bal_memory";
        this.full = new PermChild(this.permNode + ".full");
        this.animal = new PermChild(this.permNode + ".animal");
        this.mob = new PermChild(this.permNode + ".mob");
        this.item = new PermChild(this.permNode + ".item");
        this.xp = new PermChild(this.permNode + ".xp");
        this.npc = new PermChild(this.permNode + ".npc");
        this.cart = new PermChild(this.permNode + ".cart");
        this.boat = new PermChild(this.permNode + ".boat");
        this.vehicle = new PermChild(this.permNode + ".vehicle");
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        if (args.hasFlag('f') && !PermissionManager.hasPerm(sender, this.full.getBukkitPerm())) {
            return;
        }
        if (args.hasFlag('a') && !PermissionManager.hasPerm(sender, this.animal.getBukkitPerm())) {
            return;
        }
        if (args.hasFlag('m') && !PermissionManager.hasPerm(sender, this.mob.getBukkitPerm())) {
            return;
        }
        if (args.hasFlag('i') && !PermissionManager.hasPerm(sender, this.item.getBukkitPerm())) {
            return;
        }
        if (args.hasFlag('x') && !PermissionManager.hasPerm(sender, this.xp.getBukkitPerm())) {
            return;
        }
        if (args.hasFlag('n') && !PermissionManager.hasPerm(sender, this.npc.getBukkitPerm())) {
            return;
        }
        if (args.hasFlag('c') && !PermissionManager.hasPerm(sender, this.cart.getBukkitPerm())) {
            return;
        }
        if (args.hasFlag('b') && !PermissionManager.hasPerm(sender, this.boat.getBukkitPerm())) {
            return;
        }
        if (args.hasFlag('v') && !PermissionManager.hasPerm(sender, this.vehicle.getBukkitPerm())) {
            return;
        }
        if (args.hasFlag('f') || args.hasFlag('x') || args.hasFlag('i') || args.hasFlag('m') || args.hasFlag('a') || args.hasFlag('n') || args.hasFlag('v') || args.hasFlag('c') || args.hasFlag('b')) {
            int count = 0;
            final HashMap entityList = new HashMap(sender.getServer().getWorlds().size());
            final List worlds = sender.getServer().getWorlds();
            final Semaphore sema = new Semaphore(0);
            ACPluginManager.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    for (World w : worlds) {
                        WorldServer cWorld = ((CraftWorld)w).getHandle();
                        List list = cWorld.entityList;
                        synchronized (list) {
                            entityList.put(w.getName(), new ArrayList(cWorld.entityList));
                            sema.release();
                        }
                    }
                }
            });
            for (World w : worlds) {
                try {
                    sema.acquire();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                for (Entity entity : (List)entityList.get(w.getName())) {
                    if (this.dontKill(args, entity)) continue;
                    entity.die();
                    ++count;
                }
            }
            System.gc();
            sender.sendMessage("Freed Entities : " + count);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        long usedMB = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L;
        sender.sendMessage(ChatColor.GOLD + "Max Memory : " + ChatColor.WHITE + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "MB");
        sender.sendMessage(ChatColor.DARK_RED + "Used Memory : " + ChatColor.WHITE + usedMB + "MB");
        sender.sendMessage(ChatColor.DARK_GREEN + "Free Memory : " + ChatColor.WHITE + Runtime.getRuntime().freeMemory() / 1024L / 1024L + "MB");
        for (World w : sender.getServer().getWorlds()) {
            sender.sendMessage(w.getEnvironment() + " \"" + w.getName() + "\": " + w.getLoadedChunks().length + " chunks, " + w.getEntities().size() + " entities");
        }
        long delay = 40L;
        if (args.length >= 1) {
            try {
                delay = args.getLong(0);
            }
            catch (NumberFormatException e) {
                HashMap<String, String> replace = new HashMap<String, String>();
                replace.put("number", args.getString(0));
                Utils.sI18n(sender, "NaN", replace);
                return;
            }
        }
        if (delay < 20L) {
            delay = 20L;
        }
        World world = (World)ACPluginManager.getServer().getWorlds().get(0);
        ACPluginManager.getScheduler().scheduleSyncDelayedTask((Plugin)ACHelper.getInstance().getCoreInstance(), (Runnable)new CheckTicks(System.nanoTime(), world, world.getFullTime(), sender), delay);
    }

    @Override
    public boolean argsCheck(String ... args) {
        return true;
    }

    @Override
    public void registerBukkitPerm() {
        PermParent parent = new PermParent(this.permNode + ".*");
        this.plugin.getPermissionLinker().addChildPermParent(parent, this.permParent);
        PermChild child = new PermChild(this.permNode, this.bukkitDefault);
        parent.addChild(child).addChild(this.mob).addChild(this.animal).addChild(this.xp).addChild(this.item).addChild(this.full).addChild(this.npc).addChild(this.vehicle).addChild(this.cart).addChild(this.boat);
        this.bukkitPerm = child.getBukkitPerm();
    }

    private boolean dontKill(CommandArgs args, Entity toKill) {
        boolean dontKill = true;
        if (args.hasFlag('f')) {
            boolean bl = dontKill = toKill instanceof EntityHuman || toKill instanceof EntityPainting;
        }
        if (args.hasFlag('x')) {
            boolean bl = dontKill = !(toKill instanceof EntityExperienceOrb);
        }
        if (args.hasFlag('i')) {
            boolean bl = dontKill = !(toKill instanceof EntityItem);
        }
        if (args.hasFlag('m')) {
            boolean bl = dontKill = !(toKill instanceof EntityMonster);
        }
        if (args.hasFlag('a')) {
            boolean bl = dontKill = !(toKill instanceof EntityAnimal);
        }
        if (args.hasFlag('n')) {
            boolean bl = dontKill = !(toKill instanceof EntityVillager);
        }
        if (args.hasFlag('c')) {
            boolean bl = dontKill = !(toKill instanceof EntityMinecart);
        }
        if (args.hasFlag('b')) {
            boolean bl = dontKill = !(toKill instanceof EntityBoat);
        }
        if (args.hasFlag('v')) {
            dontKill = !(toKill instanceof EntityMinecart) && !(toKill instanceof EntityBoat);
        }
        return dontKill;
    }

    private class CheckTicks
    implements Runnable {
        protected long oldNanoTime;
        protected long elapsedNanoTime;
        protected World world;
        protected long start;
        protected double ticksPerSecond;
        protected long elapsedTicks;
        protected CommandSender sender;

        public CheckTicks(long oldNanoTime, World world, long start, CommandSender sender) {
            this.oldNanoTime = oldNanoTime;
            this.world = world;
            this.start = start;
            this.sender = sender;
        }

        @Override
        public void run() {
            this.elapsedNanoTime = System.nanoTime() - this.oldNanoTime;
            this.elapsedTicks = this.world.getFullTime() - this.start;
            this.ticksPerSecond = (double)this.elapsedTicks * 1.0E9 / (double)this.elapsedNanoTime;
            this.sender.sendMessage("[AdminCmd] TPS: " + this.ticksPerSecond + " | Ticks elapsed: " + this.elapsedTicks + " | Nano Time:" + this.elapsedNanoTime);
        }
    }
}

