/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Server;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Server.ServerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class ListValues
extends ServerCommand {
    public ListValues() {
        this.permNode = "admincmd.server.list";
        this.cmdName = "bal_list";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        if (args.length == 0) {
            sender.sendMessage(ChatColor.DARK_AQUA + "Possibles Types :");
            sender.sendMessage(Arrays.toString((Object[])Type.values()));
            return;
        }
        String arg = "";
        for (String str : args) {
            arg = arg + str + " ";
        }
        if (Type.matchType(arg = arg.trim()) == null) {
            Utils.sI18n(sender, "emptyList");
            return;
        }
        List<ACPlayer> list = ACPlayer.getPlayers(arg);
        if (list != null) {
            sender.sendMessage(ChatColor.AQUA + Type.matchType(arg).display() + ChatColor.WHITE + " (" + list.size() + ") " + ChatColor.AQUA + ":");
            String buffer = "";
            for (ACPlayer value : list) {
                buffer = buffer + value.getName() + ", ";
            }
            if (!buffer.equals("")) {
                if (buffer.endsWith(", ")) {
                    buffer = buffer.substring(0, buffer.lastIndexOf(","));
                }
                sender.sendMessage(buffer);
            }
        } else {
            Utils.sI18n(sender, "emptyList");
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }
}

