/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Exceptions.WorldNotLoaded;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Player.ACPlayer;
import be.Balor.Player.IBan;
import be.Balor.Player.ITempBan;
import be.Balor.Tools.Help.String.ACMinecraftFontWidthCalculator;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.World.ACWorld;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import be.Balor.bukkit.AdminCmd.LocaleHelper;
import belgium.Balor.Workers.InvisibleWorker;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Whois
extends PlayerCommand {
    public Whois() {
        super("bal_whois", "admincmd.player.whois");
        this.other = true;
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        if (args.hasFlag('w')) {
            ACWorld w;
            block12: {
                try {
                    if (args.length >= 1) {
                        w = ACWorld.getWorld(args.getString(0));
                        break block12;
                    }
                    if (Utils.isPlayer(sender)) {
                        w = ACWorld.getWorld(((Player)sender).getWorld().getName());
                        break block12;
                    }
                    return;
                }
                catch (WorldNotLoaded e) {
                    Utils.sI18n(sender, "worldNotFound", "world", args.getString(0));
                    return;
                }
            }
            sender.sendMessage(ChatColor.GREEN + ACMinecraftFontWidthCalculator.strPadCenterChat(ChatColor.AQUA + " " + w.getName() + " " + ChatColor.GREEN, '='));
            for (Map.Entry<String, String> power : w.getInformations().entrySet()) {
                String line = ChatColor.GOLD + power.getKey() + ChatColor.WHITE + " : ";
                int sizeRemaining = 318 - ACMinecraftFontWidthCalculator.getStringWidth(line);
                line = line + ACMinecraftFontWidthCalculator.strPadLeftChat(ChatColor.GREEN + power.getValue(), sizeRemaining, ' ');
                sender.sendMessage(line);
            }
            return;
        }
        ACPlayer actarget = Utils.getACPlayer(sender, args, this.permNode);
        if (actarget == null) {
            return;
        }
        sender.sendMessage(ChatColor.AQUA + ACMinecraftFontWidthCalculator.strPadCenterChat(ChatColor.DARK_GREEN + " " + (actarget.isOnline() ? Utils.getPlayerName(actarget.getHandler(), sender) : actarget.getName()) + " " + ChatColor.AQUA, '='));
        String loginDate = ChatColor.GOLD + "Last Login" + ChatColor.WHITE + " : ";
        int logSizeRemaining = 318 - ACMinecraftFontWidthCalculator.getStringWidth(loginDate);
        loginDate = loginDate + ACMinecraftFontWidthCalculator.strPadLeftChat(ChatColor.GREEN + Utils.replaceDateAndTimeFormat(actarget, Type.Whois.LOGIN), logSizeRemaining, ' ');
        sender.sendMessage(loginDate);
        String logoutDate = ChatColor.GOLD + "Last Quit" + ChatColor.WHITE + " : ";
        int logoutSizeRemaining = 318 - ACMinecraftFontWidthCalculator.getStringWidth(logoutDate);
        logoutDate = logoutDate + ACMinecraftFontWidthCalculator.strPadLeftChat(ChatColor.GREEN + Utils.replaceDateAndTimeFormat(actarget, Type.Whois.LOGOUT), logoutSizeRemaining, ' ');
        sender.sendMessage(logoutDate);
        String presentation = ChatColor.GOLD + "Presentation" + ChatColor.WHITE + " : ";
        int presSizeRemaining = 318 - ACMinecraftFontWidthCalculator.getStringWidth(presentation);
        presentation = presentation + ACMinecraftFontWidthCalculator.strPadLeftChat(ChatColor.GREEN + actarget.getPresentation(), presSizeRemaining, ' ');
        sender.sendMessage(presentation);
        long total = actarget.getCurrentPlayedTime();
        Map<String, String> replace = Utils.playedTime(actarget.getName(), total);
        String played = ChatColor.GOLD + "Time Played" + ChatColor.WHITE + " : ";
        int strSizeRem = 318 - ACMinecraftFontWidthCalculator.getStringWidth(played);
        played = played + ACMinecraftFontWidthCalculator.strPadLeftChat(ChatColor.GREEN + Utils.I18n("elapsedTotalTime", replace), strSizeRem, ' ');
        sender.sendMessage(played);
        IBan ban = ACHelper.getInstance().getBan(actarget.getName());
        if (ban != null) {
            String banned = ChatColor.GOLD + "Banned" + ChatColor.WHITE + " : ";
            int banSizeRem = 318 - ACMinecraftFontWidthCalculator.getStringWidth(banned);
            banned = banned + ACMinecraftFontWidthCalculator.strPadLeftChat(ChatColor.GREEN + (ban instanceof ITempBan ? Utils.replaceDateAndTimeFormat(((ITempBan)ban).getEndBan()) : "Permanent"), banSizeRem, ' ');
            sender.sendMessage(banned);
        }
        for (Map.Entry<String, String> power : actarget.getPowers().entrySet()) {
            Type powerType = Type.matchType(power.getKey());
            if (powerType == Type.INVISIBLE) continue;
            String line = ChatColor.GOLD + powerType.display() + ChatColor.WHITE + " : ";
            int sizeRemaining = 318 - ACMinecraftFontWidthCalculator.getStringWidth(line);
            line = line + ACMinecraftFontWidthCalculator.strPadLeftChat(ChatColor.GREEN + power.getValue(), sizeRemaining, ' ');
            sender.sendMessage(line);
        }
        String line = ChatColor.GOLD + "invisible" + ChatColor.WHITE + " : ";
        int sizeRemaining = 318 - ACMinecraftFontWidthCalculator.getStringWidth(line);
        line = line + ACMinecraftFontWidthCalculator.strPadLeftChat(ChatColor.GREEN + String.valueOf(InvisibleWorker.getInstance().hasInvisiblePowers(actarget.getHandler()) && PermissionManager.hasPerm(sender, "admincmd.invisible.cansee", false)), sizeRemaining, ' ');
        sender.sendMessage(line);
        int level = actarget.getInformation("immunityLvl").getInt(ConfigEnum.DIMMUNITY.getInt());
        String immuLvl = ChatColor.GOLD + "Immunity Level" + ChatColor.WHITE + " : ";
        strSizeRem = 318 - ACMinecraftFontWidthCalculator.getStringWidth(immuLvl);
        immuLvl = immuLvl + ACMinecraftFontWidthCalculator.strPadLeftChat(ChatColor.GREEN + String.valueOf(level), strSizeRem, ' ');
        sender.sendMessage(immuLvl);
        String gameMode = ChatColor.GREEN + "Current GameMode: " + ChatColor.GOLD;
        String currentMode = "";
        if (actarget.isOnline()) {
            currentMode = actarget.getHandler().getGameMode() == GameMode.CREATIVE ? "Creative" : "Survival";
        } else {
            currentMode = actarget.getInformation("gameMode").getString();
            if (currentMode == null) {
                currentMode = LocaleHelper.UNKNOWN.getLocale();
            }
        }
        strSizeRem = 318 - ACMinecraftFontWidthCalculator.getStringWidth(gameMode);
        gameMode = gameMode + ACMinecraftFontWidthCalculator.strPadLeftChat(ChatColor.GREEN + String.valueOf(currentMode), strSizeRem, ' ');
        sender.sendMessage(gameMode);
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }
}

