/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Threads.RemovePowerTask;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SpyMsg
extends PlayerCommand {
    public SpyMsg() {
        this.permNode = "admincmd.player.spymsg";
        this.cmdName = "bal_spymsg";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        String timeOut = args.getValueFlag('t');
        if (Utils.isPlayer(sender)) {
            final ACPlayer acp = ACPlayer.getPlayer((Player)sender);
            if (acp.hasPower(Type.SPYMSG)) {
                acp.removePower(Type.SPYMSG);
                ACHelper.getInstance().removeSpy((Player)sender);
                Utils.sI18n(sender, "spymsgDisabled");
            } else {
                int timeOutValue;
                acp.setPower(Type.SPYMSG);
                ACHelper.getInstance().addSpy((Player)sender);
                Utils.sI18n(sender, "spymsgEnabled");
                if (timeOut == null) {
                    return;
                }
                try {
                    timeOutValue = Integer.parseInt(timeOut);
                }
                catch (Exception e) {
                    Utils.sI18n(sender, "NaN", "number", timeOut);
                    return;
                }
                final CommandSender newSender = sender;
                ACPluginManager.getScheduler().scheduleAsyncDelayedTask((Plugin)ACPluginManager.getCorePlugin(), new Runnable(){

                    @Override
                    public void run() {
                        ACHelper.getInstance().removeSpy(acp.getHandler());
                        new RemovePowerTask(acp, Type.SPYMSG, newSender).run();
                    }
                }, (long)(20 * ConfigEnum.SCALE_TIMEOUT.getInt() * timeOutValue));
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return true;
    }
}

