/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.ACPlayer;
import be.Balor.Player.PlayerManager;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import com.google.common.base.Joiner;
import java.net.InetAddress;
import java.util.List;
import java.util.TreeSet;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Search
extends PlayerCommand {
    public Search() {
        this.cmdName = "bal_search";
        this.permNode = "admincmd.player.search";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws PlayerNotFound, ActionNotPermitedException {
        if (args.hasFlag('i')) {
            String ip = args.getValueFlag('i');
            if (ip == null || ip.equals("") || ip.length() == 0) {
                return;
            }
            Player[] onPlayers = ACPluginManager.getServer().getOnlinePlayers();
            List<ACPlayer> exPlayers = PlayerManager.getInstance().getExistingPlayers();
            TreeSet<String> players = new TreeSet<String>();
            String on = "[ON] ";
            String off = "[OFF] ";
            for (Player p : onPlayers) {
                InetAddress ipAdress = p.getAddress().getAddress();
                if (ipAdress == null || !ipAdress.toString().equals(ip)) continue;
                players.add("[ON] " + p.getName());
            }
            for (ACPlayer p : exPlayers) {
                String ip2 = p.getInformation("last-ip").getString();
                if (ip2 == null || !ip2.toString().equals(ip)) continue;
                players.add("[OFF] " + p.getName());
            }
            String found = Joiner.on((String)", ").join(players);
            sender.sendMessage(found);
            return;
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null && args.length >= 1;
    }
}

