/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Tools.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlayerLocation
extends PlayerCommand {
    public PlayerLocation() {
        this.permNode = "admincmd.player.loc";
        this.cmdName = "bal_playerloc";
        this.other = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        String msg;
        Location loc;
        Player target;
        if (args.length == 0) {
            if (!Utils.isPlayer(sender)) return;
            target = (Player)sender;
            loc = target.getLocation();
            msg = "You are";
        } else {
            try {
                target = Utils.getUser(sender, args, this.permNode);
                loc = target.getLocation();
                msg = Utils.getPlayerName(target) + " is";
            }
            catch (NullPointerException ex) {
                Utils.sI18n(sender, "playerNotFound", "player", args.getString(0));
                return;
            }
        }
        sender.sendMessage(loc.getBlockX() + " X, " + loc.getBlockZ() + " Z, " + loc.getBlockY() + " Y");
        String[] facing = new String[]{"S", "SW", "W", "NW", "N", "NE", "E", "SE"};
        double yaw = ((double)loc.getYaw() + 22.5) % 360.0;
        if (yaw < 0.0) {
            yaw += 360.0;
        }
        sender.sendMessage(msg + " facing " + ChatColor.RED + facing[(int)(yaw / 45.0)] + ChatColor.WHITE + " in World " + ChatColor.AQUA + target.getWorld().getName());
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }
}

