/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Utils;
import org.bukkit.command.CommandSender;

public class Played
extends PlayerCommand {
    public Played() {
        super("bal_played", "admincmd.player.played");
        this.other = true;
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        ACPlayer target = Utils.getACPlayer(sender, args, this.permNode);
        if (target != null) {
            long total;
            String playername;
            if (target.isOnline()) {
                playername = Utils.getPlayerName(target.getHandler(), sender);
                total = target.getCurrentPlayedTime();
            } else {
                playername = target.getName();
                total = target.getInformation("totalTime").getLong(0L);
            }
            Utils.sI18n(sender, "playedTime", Utils.playedTime(playername, total));
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }
}

