/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.OpenInv.InventoryManager;
import be.Balor.Tools.Utils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class OpenInventory
extends PlayerCommand {
    public OpenInventory() {
        super("bal_openinv", "admincmd.player.openinv");
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws PlayerNotFound, ActionNotPermitedException {
        if (!Utils.isPlayer(sender)) {
            return;
        }
        String playerName = args.getString(0);
        Player target = Utils.getPlayer(playerName);
        Player pSender = (Player)sender;
        if (target == null) {
            String world = args.getValueFlag('w');
            if (world == null) {
                world = pSender.getWorld().getName();
            }
            InventoryManager.INSTANCE.openOfflineInv(pSender, playerName, world);
            return;
        }
        if (!Utils.checkImmunity(sender, target)) {
            Utils.sI18n(sender, "insufficientLvl");
            return;
        }
        InventoryManager.INSTANCE.openInv(pSender, target);
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null && args.length >= 1;
    }
}

