/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Threads.RemovePowerTask;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class NoDrop
extends PlayerCommand {
    public NoDrop() {
        super("bal_nodrop", "admincmd.player.nodrop");
        this.other = true;
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws PlayerNotFound, ActionNotPermitedException {
        String timeOut = args.getValueFlag('t');
        Player player = Utils.getUserParam(sender, args, this.permNode);
        if (player == null) {
            return;
        }
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("player", Utils.getPlayerName(player));
        ACPlayer acp = ACPlayer.getPlayer(player);
        if (acp.hasPower(Type.NO_DROP)) {
            acp.removePower(Type.NO_DROP);
            Utils.sI18n((CommandSender)player, "noDropDisabled");
            if (!player.equals(sender)) {
                Utils.sI18n(sender, "noDropDisabledTarget", replace);
            }
        } else {
            int timeOutValue;
            acp.setPower(Type.NO_DROP);
            Utils.sI18n((CommandSender)player, "noDropEnabled");
            if (!player.equals(sender)) {
                Utils.sI18n(sender, "noDropEnabledTarget", replace);
            }
            if (timeOut == null) {
                return;
            }
            try {
                timeOutValue = Integer.parseInt(timeOut);
            }
            catch (Exception e) {
                Utils.sI18n(sender, "NaN", "number", timeOut);
                return;
            }
            ACPluginManager.getScheduler().scheduleAsyncDelayedTask((Plugin)ACPluginManager.getCorePlugin(), (Runnable)new RemovePowerTask(acp, Type.NO_DROP, sender), (long)(20 * ConfigEnum.SCALE_TIMEOUT.getInt() * timeOutValue));
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }
}

