/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Manager.Permissions.PermChild;
import be.Balor.Manager.Permissions.PermParent;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Player.ACPlayer;
import be.Balor.Player.EmptyPlayer;
import be.Balor.Tools.Lister.Lister;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Mute
extends PlayerCommand {
    private final PermChild cmdMute;

    public Mute() {
        this.permNode = "admincmd.player.mute";
        this.cmdName = "bal_mute";
        this.cmdMute = new PermChild(this.permNode + ".command");
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        Player player = Utils.getPlayer(args.getString(0));
        if (args.hasFlag('c') && !PermissionManager.hasPerm(sender, this.cmdMute.getBukkitPerm())) {
            return;
        }
        if (player != null) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("player", Utils.getPlayerName(player));
            ACPlayer acp = ACPlayer.getPlayer(player.getName());
            if (acp instanceof EmptyPlayer) {
                Utils.sI18n(sender, "playerNotFound", replace);
                return;
            }
            if (!Utils.checkImmunity(sender, player)) {
                Utils.sI18n(sender, "insufficientLvl");
                return;
            }
            if (args.hasFlag('c')) {
                if (!acp.hasPower(Type.MUTED_COMMAND)) {
                    String msg = "Server Admin";
                    if (Utils.isPlayer(sender, false)) {
                        msg = Utils.getPlayerName((Player)sender);
                    }
                    if (!player.equals(sender)) {
                        Utils.sI18n(sender, "commandMuteEnabledTarget", replace);
                    }
                    if (args.length >= 2) {
                        Integer tmpMute = null;
                        try {
                            tmpMute = args.getInt(args.length - 1);
                            final String unmute = player.getName();
                            final CommandSender senderFinal = sender;
                            acp.setPower(Type.MUTED_COMMAND, "Muted(including commands) by " + msg);
                            ACPluginManager.getScheduler().scheduleAsyncDelayedTask((Plugin)this.getPlugin(), new Runnable(){

                                @Override
                                public void run() {
                                    ACPlayer.getPlayer(unmute).removePower(Type.MUTED_COMMAND);
                                    Utils.sI18n(senderFinal, "commandMuteDisabledTarget", "player", unmute);
                                    Lister list = Lister.getLister(Lister.List.MUTE, false);
                                    if (list != null) {
                                        list.update();
                                    }
                                }
                            }, (long)(1200 * tmpMute));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (tmpMute == null) {
                            acp.setPower(Type.MUTED_COMMAND, "Permanently muted(including commands) by " + msg);
                            Utils.sI18n((CommandSender)player, "commandMuteEnabled");
                        } else {
                            acp.setPower(Type.MUTED_COMMAND, "Muted(including commands) by " + msg + " for " + tmpMute + " minutes");
                            Utils.sI18n((CommandSender)player, "commandTmpMuteEnabled", "minutes", tmpMute.toString());
                        }
                    } else {
                        acp.setPower(Type.MUTED_COMMAND, "Permanently muted(including commands) by " + msg);
                        Utils.sI18n((CommandSender)player, "commandMuteEnabled");
                    }
                } else {
                    Utils.sI18n(sender, "alreadyCommandMuted");
                }
                return;
            }
            if (!acp.hasPower(Type.MUTED)) {
                String msg = "Server Admin";
                if (Utils.isPlayer(sender, false)) {
                    msg = Utils.getPlayerName((Player)sender);
                }
                if (!player.equals(sender)) {
                    Utils.sI18n(sender, "muteEnabledTarget", replace);
                }
                if (args.length >= 2) {
                    Integer tmpMute = null;
                    try {
                        tmpMute = args.getInt(args.length - 1);
                        final String unmute = player.getName();
                        final CommandSender senderFinal = sender;
                        ACPluginManager.getScheduler().scheduleAsyncDelayedTask((Plugin)this.getPlugin(), new Runnable(){

                            @Override
                            public void run() {
                                ACPlayer.getPlayer(unmute).removePower(Type.MUTED);
                                Utils.sI18n(senderFinal, "muteDisabledTarget", "player", unmute);
                                Lister list = Lister.getLister(Lister.List.MUTE, false);
                                if (list != null) {
                                    list.update();
                                }
                            }
                        }, (long)(1200 * tmpMute));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (tmpMute == null) {
                        acp.setPower(Type.MUTED, "Permanently muted by " + msg);
                        Utils.sI18n((CommandSender)player, "muteEnabled");
                    } else {
                        acp.setPower(Type.MUTED, "Muted by " + msg + " for " + tmpMute + " minutes");
                        Utils.sI18n((CommandSender)player, "tmpMuteEnabled", "minutes", tmpMute.toString());
                    }
                } else {
                    acp.setPower(Type.MUTED, "Permanently muted by " + msg);
                    Utils.sI18n((CommandSender)player, "muteEnabled");
                }
            } else {
                Utils.sI18n(sender, "alreadyMuted");
            }
            Lister list = Lister.getLister(Lister.List.MUTE, false);
            if (list != null) {
                list.update();
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null && args.length >= 1;
    }

    @Override
    public void registerBukkitPerm() {
        PermParent parent = new PermParent(this.permNode + ".*");
        this.plugin.getPermissionLinker().addChildPermParent(parent, this.permParent);
        PermChild child = new PermChild(this.permNode, this.bukkitDefault);
        parent.addChild(child).addChild(this.cmdMute);
        this.bukkitPerm = child.getBukkitPerm();
    }
}

