/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import belgium.Balor.Workers.InvisibleWorker;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;

public class Invisible
extends PlayerCommand {
    public Invisible() {
        this.permNode = "admincmd.player.invisible";
        this.cmdName = "bal_invisible";
        this.other = true;
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        Player target = Utils.getUser(sender, args, this.permNode);
        boolean noPickUp = ConfigEnum.NPINVISIBLE.getBoolean();
        if (target != null) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("player", Utils.getPlayerName(target));
            ACPlayer acp = ACPlayer.getPlayer(target);
            if (!InvisibleWorker.getInstance().hasInvisiblePowers(target)) {
                InvisibleWorker.getInstance().vanish(target, false);
                Utils.sI18n((CommandSender)target, "invisibleEnabled");
                if (noPickUp && !acp.hasPower(Type.NO_PICKUP)) {
                    acp.setPower(Type.NO_PICKUP);
                    Utils.sI18n((CommandSender)target, "npEnabled");
                }
                if (!target.equals(sender)) {
                    Utils.sI18n(sender, "invisibleEnabledTarget", replace);
                    if (noPickUp && acp.hasPower(Type.NO_PICKUP)) {
                        Utils.sI18n(sender, "npEnabledTarget", replace);
                    }
                }
                acp.setPower(Type.INVISIBLE);
            } else {
                InvisibleWorker.getInstance().reappear(target);
                Utils.sI18n((CommandSender)target, "invisibleDisabled");
                if (noPickUp && acp.hasPower(Type.NO_PICKUP)) {
                    acp.removePower(Type.NO_PICKUP);
                    Utils.sI18n((CommandSender)target, "npDisabled");
                }
                if (!target.equals(sender)) {
                    Utils.sI18n(sender, "invisibleDisabledTarget", replace);
                    if (noPickUp && !acp.hasPower(Type.NO_PICKUP)) {
                        Utils.sI18n(sender, "npDisabledTarget", replace);
                    }
                }
                acp.removePower(Type.INVISIBLE);
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }

    @Override
    public void registerBukkitPerm() {
        super.registerBukkitPerm();
        this.plugin.getPermissionLinker().addPermChild("admincmd.invisible.notatarget", PermissionDefault.OP);
        this.plugin.getPermissionLinker().addPermChild("admincmd.invisible.cansee", PermissionDefault.OP);
    }
}

