/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Threads.RemovePowerTask;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Freeze
extends PlayerCommand {
    public Freeze() {
        this.permNode = "admincmd.player.freeze";
        this.cmdName = "bal_freeze";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        String timeOut = args.getValueFlag('t');
        Player player = sender.getServer().getPlayer(args.getString(0));
        if (player != null) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("player", Utils.getPlayerName(player));
            ACPlayer acp = ACPlayer.getPlayer(player);
            if (acp.hasPower(Type.FROZEN)) {
                acp.removePower(Type.FROZEN);
                Utils.sI18n((CommandSender)player, "freezeDisabled");
                if (!player.equals(sender)) {
                    Utils.sI18n(sender, "freezeDisabledTarget", replace);
                }
            } else {
                int timeOutValue;
                acp.setPower(Type.FROZEN);
                Utils.sI18n((CommandSender)player, "freezeEnabled");
                if (!player.equals(sender)) {
                    Utils.sI18n(sender, "freezeEnabledTarget", replace);
                }
                if (timeOut == null) {
                    return;
                }
                try {
                    timeOutValue = Integer.parseInt(timeOut);
                }
                catch (Exception e) {
                    Utils.sI18n(sender, "NaN", "number", timeOut);
                    return;
                }
                ACPluginManager.getScheduler().scheduleAsyncDelayedTask((Plugin)ACPluginManager.getCorePlugin(), (Runnable)new RemovePowerTask(acp, Type.FROZEN, sender), (long)(20 * ConfigEnum.SCALE_TIMEOUT.getInt() * timeOutValue));
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null && args.length >= 1;
    }
}

