/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACHelper;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FakeQuit
extends PlayerCommand {
    public FakeQuit() {
        this.permNode = "admincmd.player.fakequit";
        this.cmdName = "bal_fakequit";
        this.other = true;
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        Player player = Utils.getUser(sender, args, this.permNode);
        if (player != null) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("player", Utils.getPlayerName(player));
            ACPlayer acp = ACPlayer.getPlayer(player.getName());
            if (acp.hasPower(Type.FAKEQUIT)) {
                acp.removePower(Type.FAKEQUIT);
                Utils.broadcastFakeJoin(player);
                Utils.addPlayerInOnlineList(player);
                ACHelper.getInstance().removeFakeQuit(player);
                Utils.sI18n((CommandSender)player, "fakeQuitDisabled");
                if (!player.equals(sender)) {
                    Utils.sI18n(sender, "fakeQuitDisabledTarget", replace);
                }
            } else {
                acp.setPower(Type.FAKEQUIT);
                Utils.sI18n((CommandSender)player, "fakeQuitEnabled");
                Utils.broadcastFakeQuit(player);
                ACHelper.getInstance().addFakeQuit(player);
                Utils.removePlayerFromOnlineList(player);
                if (!player.equals(sender)) {
                    Utils.sI18n(sender, "fakeQuitEnabledTarget", replace);
                }
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }
}

