/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;

public class Experience
extends PlayerCommand {
    public Experience() {
        this.permNode = "admincmd.player.experience";
        this.cmdName = "bal_exp";
        this.other = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        float amount = 0.0f;
        Player target = null;
        HashMap<String, String> replace = new HashMap<String, String>();
        boolean self = false;
        if (0 < args.length && args.length < 2) {
            if (!Utils.isPlayer(sender, true)) return;
            target = (Player)sender;
            self = true;
            if (!args.hasFlag('t')) {
                try {
                    amount = args.getFloat(0);
                }
                catch (NumberFormatException e) {
                    replace.put("number", args.getString(0));
                    Utils.I18n("NaN", replace);
                    return;
                }
            }
        } else if (args.length >= 2) {
            target = Utils.getPlayer(args.getString(0));
            if (!args.hasFlag('t')) {
                try {
                    amount = args.getFloat(1);
                }
                catch (NumberFormatException e) {
                    replace.put("number", args.getString(0));
                    Utils.I18n("NaN", replace);
                    return;
                }
            }
        } else {
            if (!Utils.isPlayer(sender, true)) return;
            if (args.hasFlag('t')) {
                target = (Player)sender;
                replace.put("exp", String.valueOf(target.getTotalExperience()));
                sender.sendMessage(Utils.I18n("expTotal", replace));
                return;
            }
        }
        if (target == null) {
            return;
        }
        replace.put("amount", String.valueOf(amount));
        final Player taskTarget = target;
        final float amountXp = amount;
        if (args.hasFlag('d')) {
            final Location loc = target.getLocation();
            loc.setX(loc.getX() + 2.0);
            ACPluginManager.scheduleSyncTask(new Runnable(){

                @Override
                public void run() {
                    ((ExperienceOrb)taskTarget.getLocation().getWorld().spawn(loc, ExperienceOrb.class)).setExperience((int)amountXp);
                }
            });
            if (self) {
                target.sendMessage(Utils.I18n("expDropped", replace));
                return;
            } else {
                replace.put("target", Utils.getPlayerName(target));
                target.sendMessage(Utils.I18n("expDropped", replace));
                sender.sendMessage(Utils.I18n("expDroppedTarget", replace));
            }
            return;
        } else if (args.hasFlag('a')) {
            ACPluginManager.scheduleSyncTask(new Runnable(){

                @Override
                public void run() {
                    taskTarget.giveExp((int)amountXp);
                }
            });
            if (self) {
                target.sendMessage(Utils.I18n("expAdded", replace));
                return;
            } else {
                replace.put("target", Utils.getPlayerName(target));
                sender.sendMessage(Utils.I18n("expAddedTarget", replace));
                target.sendMessage(Utils.I18n("expAdded", replace));
            }
            return;
        } else if (args.hasFlag('p')) {
            final float exp = amount > 1.0f ? 1.0f : amount;
            ACPluginManager.scheduleSyncTask(new Runnable(){

                @Override
                public void run() {
                    taskTarget.setExp(exp);
                }
            });
            replace.put("amount", String.valueOf(exp * 100.0f));
            if (self) {
                target.sendMessage(Utils.I18n("expProgressionSet", replace));
                return;
            } else {
                replace.put("target", Utils.getPlayerName(target));
                target.sendMessage(Utils.I18n("expProgressionSet", replace));
                sender.sendMessage(Utils.I18n("expProgressionSetTarget", replace));
            }
            return;
        } else if (args.hasFlag('l')) {
            ACPluginManager.scheduleSyncTask(new Runnable(){

                @Override
                public void run() {
                    taskTarget.setLevel((int)amountXp);
                }
            });
            if (self) {
                target.sendMessage(Utils.I18n("expLevelSet", replace));
                return;
            } else {
                replace.put("target", Utils.getPlayerName(target));
                target.sendMessage(Utils.I18n("expLevelSet", replace));
                sender.sendMessage(Utils.I18n("expLevelSetTarget", replace));
            }
            return;
        } else {
            if (!args.hasFlag('t')) return;
            replace.put("exp", String.valueOf(target.getTotalExperience()));
            if (self) {
                sender.sendMessage(Utils.I18n("expTotal", replace));
                return;
            } else {
                replace.put("target", Utils.getPlayerName(target));
                sender.sendMessage(Utils.I18n("expTotalTarget", replace));
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null && args.length >= 1;
    }
}

