/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Threads.RemovePowerTask;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Eternal
extends PlayerCommand {
    public Eternal() {
        this.permNode = "admincmd.player.eternal";
        this.cmdName = "bal_eternal";
        this.other = true;
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        Player player = null;
        String timeOut = args.getValueFlag('t');
        player = args.length >= 1 ? Utils.getUser(sender, args, this.permNode, 0, false) : Utils.getUser(sender, args, this.permNode);
        if (player != null) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("player", Utils.getPlayerName(player));
            ACPlayer acp = ACPlayer.getPlayer(player.getName());
            if (acp.hasPower(Type.ETERNAL)) {
                player.setFoodLevel(acp.getPower(Type.ETERNAL).getInt(20));
                acp.removePower(Type.ETERNAL);
                Utils.sI18n((CommandSender)player, "eternalDisabled");
                if (!player.equals(sender)) {
                    Utils.sI18n(sender, "eternalDisabledTarget", replace);
                }
            } else {
                int timeOutValue;
                acp.setPower(Type.ETERNAL, player.getFoodLevel());
                player.setFoodLevel(20);
                Utils.sI18n((CommandSender)player, "eternalEnabled");
                if (!player.equals(sender)) {
                    Utils.sI18n(sender, "eternalEnabledTarget", replace);
                }
                if (timeOut == null) {
                    return;
                }
                try {
                    timeOutValue = Integer.parseInt(timeOut);
                }
                catch (Exception e) {
                    Utils.sI18n(sender, "NaN", "number", timeOut);
                    return;
                }
                ACPluginManager.getScheduler().scheduleAsyncDelayedTask((Plugin)ACPluginManager.getCorePlugin(), (Runnable)new RemovePowerTask(acp, Type.ETERNAL, sender), (long)(20 * ConfigEnum.SCALE_TIMEOUT.getInt() * timeOutValue));
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }
}

