/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Tools.MaterialContainer;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ClearInventory
extends PlayerCommand {
    public ClearInventory() {
        this.permNode = "admincmd.player.clear";
        this.cmdName = "bal_pclear";
        this.other = true;
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws PlayerNotFound, ActionNotPermitedException {
        final Player target = Utils.getUserParam(sender, args, this.permNode);
        if (target == null) {
            return;
        }
        if (args.length == 1) {
            final MaterialContainer mc = ACHelper.getInstance().checkMaterial(sender, args.getString(0));
            if (mc.isNull()) {
                return;
            }
            ACPluginManager.scheduleSyncTask(new Runnable(){

                @Override
                public void run() {
                    target.getInventory().remove(mc.getMaterial());
                }
            });
        } else if (args.length >= 2) {
            final int startAmount = args.getInt(1);
            MaterialContainer mc = ACHelper.getInstance().checkMaterial(sender, args.getString(0));
            if (mc.isNull()) {
                return;
            }
            final HashMap stacks = target.getInventory().all(mc.getMaterial());
            ACPluginManager.scheduleSyncTask(new Runnable(){

                @Override
                public void run() {
                    int current = 0;
                    int tempSlot = 0;
                    int amount = startAmount;
                    for (Map.Entry stacksEntry : stacks.entrySet()) {
                        current = ((ItemStack)stacksEntry.getValue()).getAmount();
                        tempSlot = (Integer)stacksEntry.getKey();
                        if (amount < current) {
                            ItemStack tempStack = target.getInventory().getItem(tempSlot);
                            tempStack.setAmount(current - amount);
                            break;
                        }
                        if (amount == current) {
                            target.getInventory().clear(tempSlot);
                            break;
                        }
                        target.getInventory().clear(tempSlot);
                        amount -= current;
                    }
                }
            });
        } else {
            ACPluginManager.scheduleSyncTask(new Runnable(){

                @Override
                public void run() {
                    target.getInventory().clear();
                    target.getInventory().setHelmet(null);
                    target.getInventory().setChestplate(null);
                    target.getInventory().setLeggings(null);
                    target.getInventory().setBoots(null);
                }
            });
        }
        if (!sender.equals(target)) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("player", Utils.getPlayerName(target));
            Utils.sI18n(sender, "clearTarget", replace);
        }
        Utils.sI18n((CommandSender)target, "clear");
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }
}

