/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.LocaleManager;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.ACPlayer;
import be.Balor.Player.Ban;
import be.Balor.Player.BannedIP;
import be.Balor.Player.BannedPlayer;
import be.Balor.Player.ITempBan;
import be.Balor.Player.TempBannedIP;
import be.Balor.Player.TempBannedPlayer;
import be.Balor.Tools.Threads.UnBanTask;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.LocaleHelper;
import java.util.HashMap;
import java.util.regex.Matcher;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BanPlayer
extends PlayerCommand {
    public BanPlayer() {
        this.permNode = "admincmd.player.ban";
        this.cmdName = "bal_ban";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        String banPlayerString;
        Player toBan = Utils.getPlayer(args.getString(0));
        HashMap<String, String> replace = new HashMap<String, String>();
        String message = "";
        if (toBan != null) {
            banPlayerString = toBan.getName();
            if (!Utils.checkImmunity(sender, toBan)) {
                Utils.sI18n(sender, "insufficientLvl");
                return;
            }
        } else {
            banPlayerString = args.getString(0);
        }
        Integer tmpBan = null;
        if (args.length >= 2) {
            block21: {
                if (args.hasFlag('m')) {
                    message = LocaleManager.getInstance().get("kickMessages", args.getValueFlag('m'), "player", banPlayerString);
                }
                if (message == null || message != null && message.isEmpty()) {
                    message = "";
                    for (int i = 1; i < args.length - 1; ++i) {
                        message = message + args.getString(i) + " ";
                    }
                }
                try {
                    tmpBan = args.getInt(args.length - 1);
                }
                catch (Exception e) {
                    if (args.hasFlag('m')) break block21;
                    message = message + args.getString(args.length - 1);
                }
            }
            if (message.isEmpty()) {
                message = message + " You have been banned ";
            }
            message = !Utils.isPlayer(sender, false) ? message + "by Server Admin" : message + "by " + Utils.getPlayerName((Player)sender);
        } else {
            if (message.isEmpty()) {
                message = "You have been banned ";
            }
            message = !Utils.isPlayer(sender, false) ? message + "by Server Admin" : message + "by " + Utils.getPlayerName((Player)sender);
        }
        message = message.trim();
        replace.put("player", banPlayerString);
        replace.put("reason", message);
        Matcher ipv4 = Utils.REGEX_IP_V4.matcher(banPlayerString);
        Matcher inaccurateIp = Utils.REGEX_INACCURATE_IP_V4.matcher(banPlayerString);
        if (tmpBan != null) {
            Ban ban;
            message = message + " (Banned for " + tmpBan + " minutes)";
            replace.put("reason", message);
            if (inaccurateIp.find()) {
                if (!ipv4.find()) {
                    replace.clear();
                    replace.put("ip", banPlayerString);
                    LocaleHelper.INACC_IP.sendLocale(sender, replace);
                    return;
                }
                ban = new TempBannedIP(banPlayerString, message, tmpBan * 60 * 1000);
                ACHelper.getInstance().banPlayer(ban);
            } else {
                ban = new TempBannedPlayer(banPlayerString, message, tmpBan * 60 * 1000);
                ACHelper.getInstance().banPlayer(ban);
            }
            ACPluginManager.getScheduler().scheduleAsyncDelayedTask((Plugin)this.getPlugin(), (Runnable)new UnBanTask((ITempBan)((Object)ban), true), (long)(1200 * tmpBan));
        } else if (inaccurateIp.find()) {
            if (!ipv4.find()) {
                replace.clear();
                replace.put("ip", banPlayerString);
                LocaleHelper.INACC_IP.sendLocale(sender, replace);
                return;
            }
            ACHelper.getInstance().banPlayer(new BannedIP(banPlayerString, message));
        } else {
            ACHelper.getInstance().banPlayer(new BannedPlayer(banPlayerString, message));
        }
        ACPlayer.getPlayer(toBan).setPower(Type.KICKED);
        if (toBan != null) {
            final String finalmsg = message;
            final Player finalToKick = toBan;
            ACPluginManager.scheduleSyncTask(new Runnable(){

                @Override
                public void run() {
                    finalToKick.kickPlayer(finalmsg);
                }
            });
        }
        Utils.broadcastMessage(Utils.I18n("ban", replace));
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null && args.length >= 1;
    }
}

