/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Mob;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Mob.MobCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class SpawnMob
extends MobCommand {
    public SpawnMob() {
        this.permNode = "admincmd.mob.spawn";
        this.cmdName = "bal_mob";
        this.other = true;
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        if (Utils.isPlayer(sender)) {
            Location playerLoc;
            Location loc;
            int nbTaped;
            HashMap<String, String> replace = new HashMap<String, String>();
            String name = args.getString(0);
            replace.put("mob", name);
            int distance = 0;
            try {
                nbTaped = args.getInt(1);
            }
            catch (Exception e) {
                nbTaped = 1;
            }
            try {
                distance = args.getInt(2);
            }
            catch (Exception e) {
                distance = 0;
            }
            Player temp = Utils.getUser(sender, args, this.permNode, 3, false);
            if (temp == null) {
                temp = (Player)sender;
            }
            Player player = temp;
            if (distance == 0 && player.equals(sender)) {
                loc = player.getTargetBlock(null, 100).getLocation().add(0.0, 1.0, 0.0);
            } else if (distance == 0) {
                playerLoc = player.getLocation();
                loc = playerLoc.add(playerLoc.getDirection().normalize().multiply(2).toLocation(player.getWorld(), playerLoc.getYaw(), playerLoc.getPitch())).add(0.0, 1.0, 0.0);
            } else {
                playerLoc = player.getLocation();
                loc = playerLoc.add(playerLoc.getDirection().normalize().multiply(distance).toLocation(player.getWorld(), playerLoc.getYaw(), playerLoc.getPitch())).add(0.0, 1.0, 0.0);
            }
            EntityType ct = null;
            if (name.contains(":")) {
                String[] creatures = name.split(":");
                ct = EntityType.fromName((String)creatures[0]);
                EntityType ct2 = EntityType.fromName((String)creatures[1]);
                if (ct == null) {
                    replace.put("mob", creatures[0]);
                    Utils.sI18n(sender, "errorMob", replace);
                }
                if (ct2 == null) {
                    replace.put("mob", creatures[1]);
                    Utils.sI18n(sender, "errorMob", replace);
                }
                if (ct == null || ct2 == null) {
                    return;
                }
                ACPluginManager.scheduleSyncTask(new PassengerMob(loc, nbTaped, ct, ct2, player, sender));
            } else {
                ct = EntityType.fromName((String)name);
                if (ct == null) {
                    Utils.sI18n(sender, "errorMob", replace);
                    return;
                }
                ACPluginManager.scheduleSyncTask(new NormalMob(loc, nbTaped, ct, player, sender));
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null && args.length >= 1;
    }

    protected class PassengerMob
    extends NormalMob {
        protected EntityType passenger;

        public PassengerMob(Location loc, int nb, EntityType mount, EntityType passenger, Player player, CommandSender sender) {
            super(loc, nb, mount, player, sender);
            this.passenger = passenger;
        }

        @Override
        public void run() {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("mob", this.ct.getName() + "-" + this.passenger.getName());
            for (int i = 0; i < this.nb; ++i) {
                this.loc.getWorld().spawnCreature(this.loc, this.ct).setPassenger((Entity)this.loc.getWorld().spawnCreature(this.loc, this.passenger));
            }
            replace.put("nb", String.valueOf(this.nb));
            if (this.player.equals(this.sender)) {
                Utils.sI18n((CommandSender)this.player, "spawnMob", replace);
            } else {
                replace.put("player", Utils.getPlayerName((Player)this.sender));
                Utils.sI18n((CommandSender)this.player, "spawnMobOther", replace);
            }
        }
    }

    protected class NormalMob
    implements Runnable {
        protected Location loc;
        protected int nb;
        protected EntityType ct;
        protected Player player;
        protected CommandSender sender;

        public NormalMob(Location loc, int nb, EntityType ct, Player player, CommandSender sender) {
            this.loc = loc;
            this.nb = nb;
            this.ct = ct;
            this.player = player;
            this.sender = sender;
        }

        @Override
        public void run() {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("mob", this.ct.getName());
            for (int i = 0; i < this.nb; ++i) {
                this.loc.getWorld().spawnCreature(this.loc, this.ct);
            }
            replace.put("nb", String.valueOf(this.nb));
            if (this.player.equals(this.sender)) {
                Utils.sI18n((CommandSender)this.player, "spawnMob", replace);
            } else {
                replace.put("player", Utils.getPlayerName((Player)this.sender));
                Utils.sI18n((CommandSender)this.player, "spawnMobOther", replace);
            }
        }
    }
}

