/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Mob;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Mob.MobCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Exceptions.WorldNotLoaded;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.World.ACWorld;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;

public class MobLimit
extends MobCommand {
    public MobLimit() {
        this.permNode = "admincmd.mob.limit";
        this.cmdName = "bal_moblimit";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        ACWorld world = null;
        if (args.hasFlag('m')) {
            String name = args.getValueFlag('m');
            try {
                world = ACWorld.getWorld(args.getString(0));
            }
            catch (WorldNotLoaded e) {
                Utils.sI18n(sender, "worldNotFound", "world", args.getString(0));
                return;
            }
            EntityType ct = EntityType.fromName((String)name);
            if (ct == null) {
                Utils.sI18n(sender, "errorMob", "mob", name);
                return;
            }
            HashMap<String, String> replace = new HashMap<String, String>();
            try {
                int limit = args.getInt(1);
                world.setMobLimit("Craft" + ct.getName(), limit);
                replace.put("number", args.getString(1));
                replace.put("world", world.getName());
                replace.put("mob", name);
                Utils.sI18n(sender, "mobLimitPerMob", replace);
            }
            catch (NumberFormatException e) {
                if (args.getString(1).equals("none")) {
                    replace.put("world", world.getName());
                    replace.put("mob", name);
                    ACWorld.getWorld(world.getName()).removeMobLimit("Craft" + ct.getName());
                    Utils.sI18n(sender, "mobLimitRemovedPerMob", replace);
                }
                Utils.sI18n(sender, "NaN", "number", args.getString(1));
            }
            return;
        }
        try {
            world = ACWorld.getWorld(args.getString(0));
        }
        catch (WorldNotLoaded e) {
            Utils.sI18n(sender, "worldNotFound", "world", args.getString(0));
            return;
        }
        try {
            HashMap<String, String> replace = new HashMap<String, String>();
            int limit = args.getInt(1);
            world.setInformation(Type.MOB_LIMIT.toString(), limit);
            replace.put("number", args.getString(1));
            replace.put("world", args.getString(0));
            Utils.sI18n(sender, "mobLimit", replace);
        }
        catch (NumberFormatException e) {
            if (args.getString(1).equals("none")) {
                world.removeInformation(Type.MOB_LIMIT.toString());
                Utils.sI18n(sender, "mobLimitRemoved", "world", world.getName());
            }
            Utils.sI18n(sender, "NaN", "number", args.getString(1));
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null && args.length >= 2;
    }
}

