/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Items;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Items.ItemCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RepairAll
extends ItemCommand {
    public RepairAll() {
        this.permNode = "admincmd.item.repairall";
        this.cmdName = "bal_repairall";
        this.other = true;
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        final Player player = Utils.getUser(sender, args, this.permNode);
        if (player == null) {
            return;
        }
        ACPluginManager.scheduleSyncTask(new Runnable(){

            @Override
            public void run() {
                for (ItemStack item : player.getInventory().getContents()) {
                    if (item == null || !ACHelper.getInstance().repairable(item.getTypeId())) continue;
                    item.setDurability((short)0);
                }
                for (ItemStack item : player.getInventory().getArmorContents()) {
                    if (item == null) continue;
                    item.setDurability((short)0);
                }
            }
        });
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("player", Utils.getPlayerName(player));
        if (!sender.equals(player)) {
            Utils.sI18n(sender, "repairAll", replace);
        }
        Utils.sI18n((CommandSender)player, "repairAllTarget");
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }
}

