/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Items;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Items.ItemCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class More
extends ItemCommand {
    public More() {
        this.permNode = "admincmd.item.more";
        this.cmdName = "bal_itemmore";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        if (Utils.isPlayer(sender)) {
            ItemStack hand = ((Player)sender).getItemInHand();
            if (hand == null || hand.getType() == Material.AIR) {
                Utils.sI18n(sender, "errorHolding");
                return;
            }
            if (ACHelper.getInstance().inBlackListItem(sender, hand)) {
                return;
            }
            if (args.length == 0) {
                ACPluginManager.scheduleSyncTask(new HandSetAmount(hand, 64));
            } else {
                int toAdd;
                try {
                    toAdd = Integer.parseInt(args.getString(0));
                }
                catch (Exception e) {
                    return;
                }
                if (hand.getAmount() + toAdd > hand.getMaxStackSize()) {
                    int inInventory = hand.getAmount() + toAdd - hand.getMaxStackSize();
                    ACPluginManager.scheduleSyncTask(new HandSetAmount(hand, hand.getMaxStackSize()));
                    ((Player)sender).getInventory().addItem(new ItemStack[]{new ItemStack(hand.getType(), inInventory, hand.getDurability())});
                    HashMap<String, String> replace = new HashMap<String, String>();
                    replace.put("amount", String.valueOf(inInventory));
                    Utils.sI18n(sender, "moreTooMuch", replace);
                } else {
                    ACPluginManager.scheduleSyncTask(new HandSetAmount(hand, hand.getAmount() + toAdd));
                }
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }

    private class HandSetAmount
    implements Runnable {
        private final ItemStack hand;
        private final int amount;

        public HandSetAmount(ItemStack hand, int amount) {
            this.hand = hand;
            this.amount = amount;
        }

        @Override
        public void run() {
            this.hand.setAmount(this.amount);
        }
    }
}

